/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseMesDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindRepasseParams;
import br.com.elotech.portaltransparencia.contabportal.service.RepasseService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/repasses"})
public class RepasseResource {
    private static final String TIPO_RECEBIDO = "R";
    private final RepasseService service;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public RepasseResource(RepasseService service, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<List<RepasseDTO>> findRepasses(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindRepasseParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findRepasses(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findRepasses(HttpServletRequest request, HttpServletResponse response, FindRepasseParams params) throws Throwable {
        PageImpl page = new PageImpl(this.service.findRepasses(params));
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle(String.format("Repasses %s", this.getTipoRepasse(params.getTipo())));
        reportParam.setClazzDTO(RepasseDTO.class);
        reportParam.setHeaderFields("Descri\u00e7\u00e3o,Valor");
        reportParam.setFields("descricao,valorLancado");
        float[] fieldsPerc = new float[]{8.0f, 2.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{200, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage((Page)page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"mes"}, params={"conta", "tipo"})
    public ResponseEntity<List<RepasseMesDTO>> findRepasses(FindRepasseParams params) {
        if (TIPO_RECEBIDO.equals(params.getTipo())) {
            return ResponseEntity.ok((Object)this.service.findRepassesRecebidosMes(params));
        }
        return ResponseEntity.ok((Object)this.service.findRepassesEnviadosMes(params));
    }

    private String getTipoRepasse(String tipo) {
        if (TIPO_RECEBIDO.equals(tipo)) {
            return "Recebido";
        }
        return "Enviado";
    }

    @GetMapping(value={"/report/mes"})
    public ModelAndView exportRepassesMes(HttpServletRequest request, HttpServletResponse response, FindRepasseParams params) throws Throwable {
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle(String.format("Repasses %s da conta %s", this.getTipoRepasse(params.getTipo()), params.getConta()));
        reportParam.setClazzDTO(RepasseMesDTO.class);
        reportParam.setHeaderFields("Data,Valor");
        reportParam.setFields("data,valor");
        float[] fieldsPerc = new float[]{5.0f, 5.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setSumFields("valor");
        reportParam.setPage((Page)new PageImpl(this.getItensReport(params)));
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    private List<RepasseMesDTO> getItensReport(FindRepasseParams params) {
        if (TIPO_RECEBIDO.equals(params.getTipo())) {
            return this.service.findRepassesRecebidosMes(params);
        }
        return this.service.findRepassesEnviadosMes(params);
    }
}

