/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.AnexoDocumentoLiquidacaoDTO;
import br.com.elotech.contabilidade.client.dto.ArquivoDTO;
import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.contabilidade.client.dto.LiquidacaoDTO;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class EmpenhoAnexosDTO {
    private String tipoAnexo;
    private String numero;
    private Long idArquivo;
    private String nomeArquivo;
    private Long entidade;
    private Long exercicio;
    private Long empenho;
    private BigDecimal tamanhoArquivo;
    private String noAno;
    private LocalDate dataArquivo;

    public EmpenhoAnexosDTO(LiquidacaoDTO liquidacao, AnexoDocumentoLiquidacaoDTO anexo, String tipoAnexo) {
        ExercicioDTO exercicio = Optional.ofNullable(liquidacao.getExercicio()).orElse(new ExercicioDTO());
        ArquivoDTO arquivo = Optional.ofNullable(anexo.getArquivo()).orElse(new ArquivoDTO());
        this.tipoAnexo = tipoAnexo;
        this.numero = Optional.ofNullable(liquidacao.getNumeroLiquidacao()).map(String::valueOf).orElse("");
        this.idArquivo = arquivo.getId();
        this.nomeArquivo = arquivo.getNome();
        this.entidade = Optional.ofNullable(exercicio.getEntidade()).map(EntidadeDTO::getId).orElse(null);
        this.exercicio = exercicio.getExercicio();
        this.noAno = Optional.ofNullable(exercicio.getExercicio()).map(String::valueOf).orElse("");
        this.tamanhoArquivo = BigDecimal.valueOf(Optional.ofNullable(arquivo.getTamanhoArquivo()).orElse(0L));
        this.dataArquivo = arquivo.getDataCriacao();
    }

    public String getNoAno() {
        return this.noAno;
    }

    public void setNoAno(String noAno) {
        this.noAno = noAno;
    }

    public LocalDate getDataArquivo() {
        return this.dataArquivo;
    }

    public void setDataArquivo(LocalDate dataArquivo) {
        this.dataArquivo = dataArquivo;
    }

    public String getTipoAnexo() {
        return this.tipoAnexo;
    }

    public void setTipoAnexo(String tipoAnexo) {
        this.tipoAnexo = tipoAnexo;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public Long getIdArquivo() {
        return this.idArquivo;
    }

    public void setIdArquivo(Long idArquivo) {
        this.idArquivo = idArquivo;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public Long getEmpenho() {
        return this.empenho;
    }

    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    public BigDecimal getTamanhoArquivo() {
        return this.tamanhoArquivo;
    }

    public void setTamanhoArquivo(BigDecimal tamanhoArquivo) {
        this.tamanhoArquivo = tamanhoArquivo;
    }

    @Generated
    public EmpenhoAnexosDTO() {
    }
}

