/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.oxy.adm.patrimonio.client.portal.PatrimonioBemOxy;
import br.com.elotech.patrimonio.client.BemClient;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBem;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioBemDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioDetalheDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.PatrimonioBemOxyToPatrimonioBemDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PatrimonioParams;
import br.com.elotech.portaltransparencia.contabportal.service.PatrimonioBemService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PatrimonioBemServiceOxyImpl
implements PatrimonioBemService {
    private final BemClient client;

    public PatrimonioBemServiceOxyImpl(BemClient client) {
        this.client = client;
    }

    public Page<PatrimonioBemDTO> findByEntidade(Long entidade, String search, Pageable pageable) {
        StringBuilder searchBuilder = new StringBuilder();
        searchBuilder.append(" entidade==");
        searchBuilder.append(entidade);
        searchBuilder.append(" and baixado==false");
        if (search != null) {
            searchBuilder.append(" and ");
            searchBuilder.append(search);
        }
        PageRequest pageRequest = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"tipo", "numeroTombamento"});
        EloPage clientResponse = this.client.findAll(searchBuilder.toString(), (Pageable)pageRequest);
        PatrimonioBemOxyToPatrimonioBemDTO converter = new PatrimonioBemOxyToPatrimonioBemDTO();
        List responseMappedToPortalEntity = clientResponse.getContent().stream().map(arg_0 -> ((PatrimonioBemOxyToPatrimonioBemDTO)converter).convert(arg_0)).collect(Collectors.toList());
        for (PatrimonioBemDTO patrimonioBemDTO : responseMappedToPortalEntity) {
            if ("M".equals(patrimonioBemDTO.getTipo())) {
                patrimonioBemDTO.setDisplayTipoPatrimonio("M\u00f3vel");
                continue;
            }
            patrimonioBemDTO.setDisplayTipoPatrimonio(patrimonioBemDTO.getTipo());
        }
        return new PageImpl(responseMappedToPortalEntity, pageable, clientResponse.getTotalElements());
    }

    public Page<PatrimonioBemDTO> getListPatrimonioBem(Pageable pageable, PatrimonioParams params) {
        EloPage clientResponse = this.client.getListPatrimonioBem(params.toOxy(), pageable);
        List responseMappedToPortalEntity = clientResponse.getContent().stream().map(PatrimonioBemDTO::fromOxy).collect(Collectors.toList());
        return new PageImpl(responseMappedToPortalEntity, pageable, clientResponse.getTotalElements());
    }

    public PatrimonioBem findByBem(PatrimonioParams params) {
        PatrimonioBemOxy clientResponse = this.client.findById(params.toOxy());
        return new PatrimonioBem(clientResponse);
    }

    public List<PatrimonioDetalheDTO> findPatrimonioDetalhe(PatrimonioParams params) {
        return this.client.findLocaisInferioresAoLocalAtualDoBem(params.getIdOxy()).stream().map(PatrimonioDetalheDTO::new).collect(Collectors.toList());
    }

    public List<UltimaAtualizacaoDTO> findUltimasAtualizacoes(FindExercicioParams params) {
        return this.client.findUltimasAtualizacoes(params.toOxyPatrimonioObject()).stream().map(UltimaAtualizacaoDTO::fromOxyPatrimonioObject).collect(Collectors.toList());
    }

    public List<PatrimonioAlienacao> findAllAlienacoes() {
        return this.client.findAllOperacoes().stream().map(PatrimonioAlienacao::fromOxy).collect(Collectors.toList());
    }
}

