/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.QPortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class AtendimentoService {
    private final PortalParametroRepository portalParametroRepository;
    private final EntidadeContabilidadeService entidadeService;

    @Autowired
    public AtendimentoService(PortalParametroRepository portalParametroRepository, EntidadeContabilidadeService entidadeService) {
        this.portalParametroRepository = portalParametroRepository;
        this.entidadeService = entidadeService;
    }

    public List<PortalParametroContabil> getAtendimento(Long entidade) {
        Entidade entidadeObj = this.entidadeService.getEntidadeSelecionada(entidade);
        Iterable list = this.portalParametroRepository.findAll((Predicate)QPortalParametroContabil.portalParametroContabil.id().id.in((Object[])new Long[]{Parametros.PARAM_ATENDIMENTO_ORGAO, Parametros.PARAM_ATENDIMENTO_ENDERECO, Parametros.PARAM_ATENDIMENTO_CIDADE, Parametros.PARAM_ATENDIMENTO_TELEFONE, Parametros.PARAM_ATENDIMENTO_EMAIL, Parametros.PARAM_ATENDIMENTO_EXPEDIENTE}).and((Predicate)QPortalParametroContabil.portalParametroContabil.id().entidade.in((Object[])new Long[]{entidadeObj.getId()})), this.sortById());
        return Lists.newArrayList((Iterable)list);
    }

    private Sort sortById() {
        return Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"id.id"});
    }
}

