/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain;

import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.ExercicioPK;
import br.com.elotech.portaltransparencia.contabportal.domain.ModeloDespesa;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="siscop.EXERCICIO")
public class Exercicio
implements EloEntity<ExercicioPK> {
    @EmbeddedId
    private ExercicioPK id;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean aberto;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean fechado;
    @Column(name="IDARQUIVOORGANOGRAMA")
    private Long idOrganograma;
    private Long anoBasePPA;
    @ManyToOne
    @JoinColumn(name="MODELODESPESA", referencedColumnName="MODELODESPESA")
    @NotFound(action=NotFoundAction.IGNORE)
    private ModeloDespesa modeloDespesa;

    public static Boolean isPrincipal(Exercicio exercicio) {
        return Long.valueOf(1L).equals(exercicio.getId().getEntidade().getEntidadePrincipal());
    }

    public static Exercicio fromExercicioContabilidade(ExercicioDTO dto) {
        Exercicio exercicio = new Exercicio();
        ExercicioPK exercicioPK = new ExercicioPK();
        exercicioPK.setEntidade(Entidade.fromEntidadeContabilidade((EntidadeDTO)dto.getEntidade()));
        exercicioPK.setExercicio(dto.getExercicio());
        exercicio.setAnoBasePPA(dto.getExercicio());
        exercicio.setId(exercicioPK);
        exercicio.setAberto(dto.getAberto());
        return exercicio;
    }

    public Long getExercicio() {
        return this.getId().getExercicio();
    }

    public Long getEntidadeId() {
        return this.getId().getEntidade().getId();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Exercicio)) {
            return false;
        }
        Exercicio other = (Exercicio)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ExercicioPK this$id = this.getId();
        ExercicioPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Exercicio;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExercicioPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Exercicio(id=" + this.getId() + ", aberto=" + this.getAberto() + ", fechado=" + this.getFechado() + ", idOrganograma=" + this.getIdOrganograma() + ", anoBasePPA=" + this.getAnoBasePPA() + ", modeloDespesa=" + this.getModeloDespesa() + ")";
    }

    @Generated
    public Exercicio() {
    }

    @Generated
    public ExercicioPK getId() {
        return this.id;
    }

    @Generated
    public Boolean getAberto() {
        return this.aberto;
    }

    @Generated
    public Boolean getFechado() {
        return this.fechado;
    }

    @Generated
    public Long getIdOrganograma() {
        return this.idOrganograma;
    }

    @Generated
    public Long getAnoBasePPA() {
        return this.anoBasePPA;
    }

    @Generated
    public ModeloDespesa getModeloDespesa() {
        return this.modeloDespesa;
    }

    @Generated
    public void setId(ExercicioPK id) {
        this.id = id;
    }

    @Generated
    public void setAberto(Boolean aberto) {
        this.aberto = aberto;
    }

    @Generated
    public void setFechado(Boolean fechado) {
        this.fechado = fechado;
    }

    @Generated
    public void setIdOrganograma(Long idOrganograma) {
        this.idOrganograma = idOrganograma;
    }

    @Generated
    public void setAnoBasePPA(Long anoBasePPA) {
        this.anoBasePPA = anoBasePPA;
    }

    @Generated
    public void setModeloDespesa(ModeloDespesa modeloDespesa) {
        this.modeloDespesa = modeloDespesa;
    }
}

