/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.legislacaoportal.domain;

import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class DiarioOficialParams {
    public static final int HOUR = 23;
    public static final int MINUTE = 59;
    private Long numero;
    private Long tipo;
    private Long mesPublicacao;
    private Long anoPublicacao;
    private String palavraChave;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME, pattern="yyyy-MM-dd")
    private LocalDate dataInicio;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME, pattern="yyyy-MM-dd")
    private LocalDate dataFim;

    public Optional<Long> getNumero() {
        return Optional.ofNullable(this.numero);
    }

    public Optional<Long> getTipo() {
        return Optional.ofNullable(this.tipo);
    }

    public Optional<Long> getMesPublicacao() {
        return Optional.ofNullable(this.mesPublicacao);
    }

    public Optional<Long> getAnoPublicacao() {
        return Optional.ofNullable(this.anoPublicacao);
    }

    public Optional<String> getPalavraChave() {
        return Optional.ofNullable(this.palavraChave);
    }

    public Optional<LocalDate> getDataInicio() {
        return Optional.ofNullable(this.dataInicio);
    }

    public Optional<LocalDate> getDataFim() {
        return Optional.ofNullable(this.dataFim);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addNumero(params);
        this.addTipo(params);
        this.addMesPublicacao(params);
        this.addAnoPublicacao(params);
        this.addPalavraChave(params);
        this.addDataInicio(params);
        this.addDataFim(params);
        return params;
    }

    private void addNumero(MapSqlParameterSource params) {
        if (this.getNumero().isPresent()) {
            params.addValue("numero", (Object)this.numero, 2);
        }
    }

    private void addTipo(MapSqlParameterSource params) {
        if (this.getTipo().isPresent()) {
            params.addValue("tipo", (Object)this.tipo, 2);
        }
    }

    private void addPalavraChave(MapSqlParameterSource params) {
        if (this.getPalavraChave().isPresent()) {
            params.addValue("palavraChave", (Object)SqlUtils.toSqlLike((String)this.palavraChave), 12);
        }
    }

    private void addMesPublicacao(MapSqlParameterSource params) {
        if (this.getMesPublicacao().isPresent()) {
            params.addValue("mesPublicacao", (Object)this.mesPublicacao, 2);
        }
    }

    private void addAnoPublicacao(MapSqlParameterSource params) {
        if (this.getAnoPublicacao().isPresent()) {
            params.addValue("anoPublicacao", (Object)this.anoPublicacao, 2);
        }
    }

    private void addDataInicio(MapSqlParameterSource params) {
        if (this.getDataInicio().isPresent()) {
            params.addValue("dataInicio", (Object)LocalDateTime.of(this.dataInicio, LocalTime.of(0, 0)), 93);
        }
    }

    private void addDataFim(MapSqlParameterSource params) {
        if (this.getDataFim().isPresent()) {
            params.addValue("dataFim", (Object)LocalDateTime.of(this.dataFim, LocalTime.of(23, 59)), 93);
        }
    }

    @Generated
    public DiarioOficialParams() {
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setTipo(Long tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setMesPublicacao(Long mesPublicacao) {
        this.mesPublicacao = mesPublicacao;
    }

    @Generated
    public void setAnoPublicacao(Long anoPublicacao) {
        this.anoPublicacao = anoPublicacao;
    }

    @Generated
    public void setPalavraChave(String palavraChave) {
        this.palavraChave = palavraChave;
    }

    @Generated
    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Generated
    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiarioOficialParams)) {
            return false;
        }
        DiarioOficialParams other = (DiarioOficialParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Optional this$numero = this.getNumero();
        Optional other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !((Object)this$numero).equals(other$numero)) {
            return false;
        }
        Optional this$tipo = this.getTipo();
        Optional other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !((Object)this$tipo).equals(other$tipo)) {
            return false;
        }
        Optional this$mesPublicacao = this.getMesPublicacao();
        Optional other$mesPublicacao = other.getMesPublicacao();
        if (this$mesPublicacao == null ? other$mesPublicacao != null : !((Object)this$mesPublicacao).equals(other$mesPublicacao)) {
            return false;
        }
        Optional this$anoPublicacao = this.getAnoPublicacao();
        Optional other$anoPublicacao = other.getAnoPublicacao();
        if (this$anoPublicacao == null ? other$anoPublicacao != null : !((Object)this$anoPublicacao).equals(other$anoPublicacao)) {
            return false;
        }
        Optional this$palavraChave = this.getPalavraChave();
        Optional other$palavraChave = other.getPalavraChave();
        if (this$palavraChave == null ? other$palavraChave != null : !((Object)this$palavraChave).equals(other$palavraChave)) {
            return false;
        }
        Optional this$dataInicio = this.getDataInicio();
        Optional other$dataInicio = other.getDataInicio();
        if (this$dataInicio == null ? other$dataInicio != null : !((Object)this$dataInicio).equals(other$dataInicio)) {
            return false;
        }
        Optional this$dataFim = this.getDataFim();
        Optional other$dataFim = other.getDataFim();
        return !(this$dataFim == null ? other$dataFim != null : !((Object)this$dataFim).equals(other$dataFim));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DiarioOficialParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : ((Object)$numero).hashCode());
        Optional $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : ((Object)$tipo).hashCode());
        Optional $mesPublicacao = this.getMesPublicacao();
        result = result * 59 + ($mesPublicacao == null ? 43 : ((Object)$mesPublicacao).hashCode());
        Optional $anoPublicacao = this.getAnoPublicacao();
        result = result * 59 + ($anoPublicacao == null ? 43 : ((Object)$anoPublicacao).hashCode());
        Optional $palavraChave = this.getPalavraChave();
        result = result * 59 + ($palavraChave == null ? 43 : ((Object)$palavraChave).hashCode());
        Optional $dataInicio = this.getDataInicio();
        result = result * 59 + ($dataInicio == null ? 43 : ((Object)$dataInicio).hashCode());
        Optional $dataFim = this.getDataFim();
        result = result * 59 + ($dataFim == null ? 43 : ((Object)$dataFim).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DiarioOficialParams(numero=" + this.getNumero() + ", tipo=" + this.getTipo() + ", mesPublicacao=" + this.getMesPublicacao() + ", anoPublicacao=" + this.getAnoPublicacao() + ", palavraChave=" + this.getPalavraChave() + ", dataInicio=" + this.getDataInicio() + ", dataFim=" + this.getDataFim() + ")";
    }
}

