/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AudienciasPublicasDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.AudienciasPublicasRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AudienciasPublicasParams;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AudienciasPublicasService {
    private final AudienciasPublicasRepository audienciasPublicasRepository;
    private final ArquivoService arquivoService;

    public AudienciasPublicasService(AudienciasPublicasRepository audienciasPublicasRepository, ArquivoService arquivoService) {
        this.audienciasPublicasRepository = audienciasPublicasRepository;
        this.arquivoService = arquivoService;
    }

    public Page<AudienciasPublicasDTO> getAudienciasPublicas(Pageable pageable, AudienciasPublicasParams params) {
        return this.audienciasPublicasRepository.findAudienciasPublicas(pageable, params);
    }

    public AudienciasPublicasDTO getAudienciasPublicasDetalhes(AudienciasPublicasParams params) {
        return this.audienciasPublicasRepository.findAudienciasPublicasDetalhes(params).stream().findFirst().orElse(null);
    }

    public List<ArquivoPessoalDTO> findArquivos(AudienciasPublicasParams params) {
        return this.audienciasPublicasRepository.findArquivos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }
}

