/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.portaltransparencia.contabportal.domain.CartaServicos;
import br.com.elotech.portaltransparencia.contabportal.domain.CartaServicosPK;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.CartaServicosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.converter.CartaServicosConverter;
import br.com.elotech.portaltransparencia.contabportal.service.CartaServicosService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/carta-servicos", "/admin/carta-servicos"})
public class CartaServicosResource {
    private final CartaServicosService cartaServicosService;
    private final BaseExport baseExport;

    public CartaServicosResource(CartaServicosService cartaServicosService, BaseExport baseExport) {
        this.cartaServicosService = cartaServicosService;
        this.baseExport = baseExport;
    }

    @GetMapping
    public ResponseEntity<List<CartaServicos>> findByEntidade(@RequestHeader(value="entidade") Long entidade, @RequestParam(value="filtro") String filtro) {
        return ResponseEntity.ok((Object)this.cartaServicosService.findByEntidadeAndFiltro(entidade, filtro));
    }

    @GetMapping(value={"/report/{exportType}"})
    public ModelAndView findByEntidadeExport(@PathVariable String exportType, @RequestHeader(value="entidade") Long entidade, @RequestParam(value="filtro") String filtro, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ReportParam param = new ReportParam();
        param.setReportTitle("Listagem de Carta de Servi\u00e7os aos Usu\u00e1rios");
        param.setClazzDTO(CartaServicos.class);
        param.setFields("titulo,descricao");
        float[] fieldsPerc = new float[]{6.0f, 4.0f};
        param.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{300, 200};
        param.setWidthsFieldsTab(fieldTab);
        param.setPage((Page)new PageImpl(this.cartaServicosService.findByEntidadeAndFiltro(entidade, filtro)));
        param.setRequest(request);
        param.setResponse(response);
        param.setReportType(exportType);
        return this.baseExport.toExport(param);
    }

    @GetMapping(value={"/entidade/{entidade}"})
    public ResponseEntity<Page<CartaServicosDTO>> findByEntidade(@PathVariable(value="entidade") Long entidade, Pageable page) {
        return ResponseEntity.ok((Object)this.cartaServicosService.findByEntidade(entidade, page).map(CartaServicosConverter::toDTO));
    }

    @PostMapping
    public ResponseEntity<CartaServicosDTO> save(@RequestBody CartaServicosDTO cartaServicosDTO) throws URISyntaxException {
        CartaServicos saved = this.cartaServicosService.save(CartaServicosConverter.toEntity((CartaServicosDTO)cartaServicosDTO));
        return ResponseEntity.created((URI)new URI("")).body((Object)CartaServicosConverter.toDTO((CartaServicos)saved));
    }

    @PutMapping(params={"id", "entidade"})
    public ResponseEntity<CartaServicosDTO> update(@RequestBody CartaServicosDTO cartaServicosDTO, Long id, Long entidade) {
        CartaServicosPK pk = new CartaServicosPK(entidade, id);
        CartaServicos cartaServicos = this.cartaServicosService.findOne(pk);
        if (Objects.isNull(cartaServicos)) {
            throw RestException.notFound();
        }
        CartaServicosConverter.insertDTOtoEntity((CartaServicosDTO)cartaServicosDTO, (CartaServicos)cartaServicos);
        return ResponseEntity.ok((Object)CartaServicosConverter.toDTO((CartaServicos)this.cartaServicosService.save(cartaServicos)));
    }

    @DeleteMapping(params={"id", "entidade"})
    public ResponseEntity<Void> remove(Long id, Long entidade) {
        CartaServicosPK pk = new CartaServicosPK(entidade, id);
        CartaServicos cartaServicos = this.cartaServicosService.findOne(pk);
        if (Objects.isNull(cartaServicos)) {
            return ResponseEntity.notFound().build();
        }
        this.cartaServicosService.remove(cartaServicos);
        return ResponseEntity.ok().build();
    }

    @GetMapping(params={"id", "entidade"})
    public ResponseEntity<CartaServicosDTO> findOne(Long id, Long entidade) {
        CartaServicosPK pk = new CartaServicosPK(entidade, id);
        CartaServicos cartaServicos = this.cartaServicosService.findOne(pk);
        if (Objects.isNull(cartaServicos)) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)CartaServicosConverter.toDTO((CartaServicos)cartaServicos));
    }
}

