SELECT *
  FROM
(SELECT F.ENTIDADE,  
      TRIM(P.NOME) AS NOME,
      P.CNPJ_CPF,
      F.MATRICULA,  
      (SELECT CASE
          WHEN SF.SITUACAO = 1 THEN 'ATIVO'
          WHEN SF.SITUACAO = 2 AND (EXISTS ( SELECT DISTINCT MA.ENTIDADE
             FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
            WHERE MA.ENTIDADE = SF.ENTIDADE AND MA.MATRICULA = SF.MATRICULA AND MA.DATAINICIAL = (( SELECT MAX(MA_1.DATAINICIAL) AS DATAINICIAL
                     FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA_1
                    WHERE MA_1.ENTIDADE = SF.ENTIDADE AND MA_1.MATRICULA = SF.MATRICULA 
                      AND (((${db.aise.schema}.BUSCAANO(:dataAtual) = :exercicio) AND (MA_1.DATAFINAL >= :dataAtual))  OR (MA_1.DATAFINAL >= ${db.aise.schema}.FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) OR MA_1.DATAFINAL IS NULL) ) )))) THEN (('AFASTADO - ' || COALESCE(( SELECT A.DESCRICAO
             FROM ${db.aise.schema}.RHAFASTAMENTO A
            WHERE A.ENTIDADE = SF.ENTIDADE AND A.AFASTAMENTO = (( SELECT MAX(MA.AFASTAMENTO) AS MAX
                     FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
                    WHERE MA.ENTIDADE = SF.ENTIDADE AND MA.MATRICULA = SF.MATRICULA AND MA.DATAINICIAL = (( SELECT MAX(MA_1.DATAINICIAL) AS DATAINICIAL
                             FROM ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA_1
                            WHERE MA_1.ENTIDADE = SF.ENTIDADE AND MA_1.MATRICULA = SF.MATRICULA AND (((${db.aise.schema}.BUSCAANO(:dataAtual) = :exercicio) AND (MA_1.DATAFINAL >= :dataAtual)) OR (MA_1.DATAFINAL >= ${db.aise.schema}.FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) OR MA_1.DATAFINAL IS NULL) )  ))))), ' ')) || ' ') ||
                            COALESCE(( SELECT DISTINCT 'LICENÇA PRÊMIO' AS TEXT
             FROM ${db.aise.schema}.RHPROGRAMACAOPREMIO A
            WHERE A.ENTIDADE = SF.ENTIDADE 
              AND A.MATRICULA = SF.MATRICULA
              AND (((${db.aise.schema}.BUSCAANO(:dataAtual) = :exercicio) AND (A.FIMGOZO >= :dataAtual)) OR (A.FIMGOZO >= ${db.aise.schema}.FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12)))
              AND (((${db.aise.schema}.BUSCAANO(:dataAtual) = :exercicio) AND (A.INICIOGOZO <= :dataAtual)) OR (A.INICIOGOZO <= ${db.aise.schema}.FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12)))), '')
              WHEN SF.SITUACAO = 3 AND (EXISTS ( SELECT MP.ENTIDADE
             FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
               JOIN ${db.aise.schema}.RHPROGRAMACAORESCISAO PR ON MP.ENTIDADE = PR.ENTIDADE AND MP.MATRICULA = PR.MATRICULA AND MP.MOVIMENTACAO = PR.MOVIMENTACAO
               JOIN ${db.aise.schema}.RHRESCISAO R ON PR.ENTIDADE = R.ENTIDADE AND PR.RESCISAO = R.RESCISAO AND PR.CLASSE = R.CLASSE
            WHERE MP.ENTIDADE = SF.ENTIDADE AND MP.MATRICULA = SF.MATRICULA AND MP.TIPOMOVIMENTACAO = 7 AND (R.MOTIVO NOT IN (70, 71, 72, 73, 74, 75, 76, 77, 78, 79)))) THEN 'EXONERADO'
          WHEN SF.SITUACAO = 3 AND (EXISTS ( SELECT MP.ENTIDADE
             FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
               LEFT JOIN ${db.aise.schema}.RHPROGRAMACAORESCISAO PR ON MP.ENTIDADE = PR.ENTIDADE AND MP.MATRICULA = PR.MATRICULA AND MP.MOVIMENTACAO = PR.MOVIMENTACAO
               LEFT JOIN ${db.aise.schema}.RHRESCISAO R ON PR.ENTIDADE = R.ENTIDADE AND PR.RESCISAO = R.RESCISAO AND PR.CLASSE = R.CLASSE
            WHERE MP.ENTIDADE = SF.ENTIDADE AND MP.MATRICULA = SF.MATRICULA AND ((MP.TIPOMOVIMENTACAO IN (8, 9, 10, 11)) OR MP.TIPOMOVIMENTACAO = 7 AND (R.MOTIVO IN (70, 71, 72, 73, 74, 75, 76, 77, 78, 79))))) THEN 'APOSENTADO'
          WHEN SF.SITUACAO = 3 THEN 'DEMITIDO'
          ELSE 'ATIVO'
       END AS SITUACAO
      FROM ${db.aise.schema}.RHHISTORICOFUNCIONARIO SF
      WHERE SF.ANOCOMPETENCIA = :exercicio
        AND SF.ENTIDADE = F.ENTIDADE
        AND SF.MATRICULA = F.MATRICULA
        AND SF.TIPOFOLHA = ${db.aise.schema}.FNC_GETTIPOFOLHAPRINCIPAL(F.ENTIDADE)
        AND SF.MESCOMPETENCIA = (( SELECT MAX(HFX.MESCOMPETENCIA) AS MAX
                                     FROM ${db.aise.schema}.RHHISTORICOFUNCIONARIO HFX
                                    WHERE HFX.ENTIDADE = SF.ENTIDADE
                                      AND HFX.MATRICULA = SF.MATRICULA
                                      AND HFX.ANOCOMPETENCIA = SF.ANOCOMPETENCIA
                                      AND HFX.TIPOFOLHA = SF.TIPOFOLHA))) SITUACAO,
      F.DATAADMISSAO,
      CASE WHEN COALESCE(HF.SITUACAO, F.SITUACAO) = 3 THEN F.DATASITUACAO ELSE NULL END AS DATADEMISSAO,
      (SELECT COALESCE(MAX(CARGOMOV.DESCRICAO), C.DESCRICAO)
         FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
         LEFT OUTER JOIN ${db.aise.schema}.RHMOVIMENTACAOOUTROS MO
           ON MP.MOVIMENTACAO = MO.MOVIMENTACAO
          AND MP.ENTIDADE = MO.ENTIDADE
          AND MP.MATRICULA = MO.MATRICULA
         LEFT OUTER JOIN ${db.aise.schema}.RHCARGO CARGOMOV
           ON MO.ENTIDADE = CARGOMOV.ENTIDADE 
          AND MO.CARGO = CARGOMOV.CARGO 
        WHERE MP.MATRICULA = F.MATRICULA 
          AND MP.ENTIDADE = F.ENTIDADE
          AND MP.TIPOMOVIMENTACAO IN (59, 99)
          AND ((MO.DATAFIM IS NULL) OR (MO.DATAFIM >= :dataAtual))
          AND EXTRACT(YEAR FROM MO.DATAINICIO) <= :exercicio
      ) AS DESCRICAOCARGO,  
      CL.DESCRICAO AS DESCRICAOCLASSE,  
      RDC.DESCRICAO AS DESCRICAONATUREZA,
      RDC.DEFINICAO,
      COALESCE(RLD.DESCRICAO, RL.DESCRICAO) AS DESCRICAOLOTACAO,
      COALESCE(HF.FAIXA, F.FAIXA) FAIXA,
      LOCALTRAB.DESCRICAO AS LOCALTRABALHO,
      HOR.ENTRADA AS HORARIOENTRADA,
      HOR.SAIDAINTERVALO AS HORARIOSAIDAINTERVALO,
      HOR.ENTRADAINTERVALO AS HORARIOENTRADAINTERVALO,
      HOR.SAIDA AS HORARIOSAIDA,
      HOR.PERMITEFLEXIBILIDADE AS HORARIOESPECIAL,
  (SELECT COALESCE(MAX(CN.DESCRICAO || ' - ' || COALESCE(FC.FAIXA, '')),
                   MAX(FC.DESCRICAO || ' - ' || COALESCE(FC.FAIXA, ''))) 
     FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
    JOIN ${db.aise.schema}.RHTIPOMOVIMENTACAO TM
      ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
    JOIN ${db.aise.schema}.RHMOVIMENTACAOOUTROS MO
      ON MP.ENTIDADE = MO.ENTIDADE
     AND MP.MATRICULA = MO.MATRICULA
     AND MP.MOVIMENTACAO = MO.MOVIMENTACAO
    LEFT OUTER JOIN ${db.aise.schema}.RHCARGO CN
      ON CN.ENTIDADE = MO.ENTIDADE
     AND CN.CARGO = MO.CARGO
    LEFT OUTER JOIN ${db.aise.schema}.RHFUNCAO FC
      ON MO.ENTIDADE = FC.ENTIDADE
     AND MO.FUNCAO = FC.FUNCAO
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND (((MP.TIPOMOVIMENTACAO IN (59, 60, 102))
           AND (MO.OPCAOSALARIO IN ('N', 'D', 'C')))
              OR (MP.TIPOMOVIMENTACAO IN (45, 58, 99)))
               AND (MO.OPCAOSALARIO IS NULL OR MO.OPCAOSALARIO <> 'O')
      AND ((MO.DATAFIM IS NULL) OR (MO.DATAFIM > :dataAtual))
   ) NOMEACAO,
   (SELECT MAX(CASE WHEN ML.TIPOBENEFICIO = 'N' THEN 'CEDIDO SEM ÔNUS - ' || COALESCE(P.NOME,' ')
        ELSE 'CEDIDO COM ÔNUS - ' || COALESCE(P.NOME,' ') END)
     FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
     JOIN ${db.aise.schema}.RHTIPOMOVIMENTACAO TM
       ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
     JOIN ${db.aise.schema}.RHMOVIMENTACAOLEGAL ML
       ON MP.ENTIDADE = ML.ENTIDADE
      AND MP.MATRICULA = ML.MATRICULA
      AND MP.MOVIMENTACAO = ML.MOVIMENTACAO
     LEFT OUTER JOIN ${db.aise.schema}.PESSOA P
       ON ML.PESSOA = P.PESSOA
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND MP.TIPOMOVIMENTACAO = 90
     AND ((ML.DATATERMINO IS NULL) OR (ML.DATATERMINO > :dataAtual))
   ) CEDIDO,
   (SELECT MAX(CASE WHEN MA.TIPO = '6' THEN 'CEDIDO SEM ÔNUS - ' || COALESCE(P.NOME,' ')
     ELSE 'CEDIDO COM ÔNUS - ' || COALESCE(P.NOME,' ') END)
     FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
     JOIN ${db.aise.schema}.RHTIPOMOVIMENTACAO TM
       ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
     JOIN ${db.aise.schema}.RHMOVIMENTACAOAFASTAMENTO MA
       ON MP.ENTIDADE = MA.ENTIDADE
      AND MP.MATRICULA = MA.MATRICULA
      AND MP.MOVIMENTACAO = MA.MOVIMENTACAO
     LEFT OUTER JOIN ${db.aise.schema}.PESSOA P
       ON MA.PESSOA = P.PESSOA
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND MP.TIPOMOVIMENTACAO = 23
      AND ((MA.DATAFINAL IS NULL) OR (MA.DATAFINAL > :dataAtual))
   ) CEDIDOPARA,
   F.ADMISSAOEXCEPCIONAL
   FROM ${db.aise.schema}.RHFUNCIONARIO F
   LEFT OUTER JOIN ${db.aise.schema}.RHHISTORICOFUNCIONARIO HF
     ON F.ENTIDADE = HF.ENTIDADE
    AND F.MATRICULA = HF.MATRICULA
    AND HF.TIPOFOLHA = ${db.aise.schema}.FNC_GETTIPOFOLHAPRINCIPAL(F.ENTIDADE)
    AND HF.ANOCOMPETENCIA = :exercicio
    AND HF.MESCOMPETENCIA = 12
   LEFT OUTER JOIN ${db.aise.schema}.PESSOA  P
     ON F.PESSOA = P.PESSOA
   LEFT OUTER JOIN ${db.aise.schema}.RHCARGO C
     ON F.ENTIDADE = C.ENTIDADE     
    AND COALESCE(HF.CARGO, F.CARGO) = C.CARGO
   LEFT OUTER JOIN ${db.aise.schema}.RHCLASSE CL
     ON F.ENTIDADE = CL.ENTIDADE     
    AND COALESCE(HF.CLASSE, F.CLASSE) = CL.CLASSE    
   LEFT OUTER JOIN ${db.aise.schema}.RHDEFINICAOCLASSE RDC
     ON CL.DEFINICAO = RDC.DEFINICAO     
   LEFT OUTER JOIN ${db.aise.schema}.RHLOTACAO RL
     ON F.ENTIDADE = RL.ENTIDADE      
    AND COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = RL.MODELOLOTACAO      
    AND COALESCE(HF.NIVELLOTACAO, F.NIVELLOTACAO) = RL.NIVELLOTACAO      
    AND COALESCE(HF.LOTACAO, F.LOTACAO) = RL.LOTACAO
   LEFT OUTER JOIN ${db.aise.schema}.RHMODELOLOTACAO ML
     ON COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = ML.MODELOLOTACAO
   LEFT OUTER JOIN ${db.aise.schema}.RHNIVELMODELOLOTACAO NML
     ON ML.MODELOLOTACAO = NML.MODELOLOTACAO
    AND ML.NIVELDESCRICAOPORTALTRANSP = NML.NIVELLOTACAO
   LEFT OUTER JOIN ${db.aise.schema}.RHLOTACAO RLD
     ON F.ENTIDADE = RLD.ENTIDADE
    AND COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = RLD.MODELOLOTACAO
    AND NML.NIVELLOTACAO = RLD.NIVELLOTACAO
    AND COALESCE(HF.NIVELLOTACAO, F.NIVELLOTACAO) > NML.NIVELLOTACAO
    AND RLD.LOTACAO = SUBSTR(COALESCE(HF.LOTACAO, F.LOTACAO), 1, (NML.POSICAO + NML.TAMANHO) - 1)
  LEFT OUTER JOIN ${db.aise.schema}.RHLOCALDETRABALHO LOCALTRAB
    ON COALESCE(HF.LOCALDETRABALHO, F.LOCALDETRABALHO) = LOCALTRAB.LOCALDETRABALHO
  LEFT OUTER JOIN ${db.aise.schema}.RHHORARIOTRABALHO HOR
    ON F.ENTIDADE = HOR.ENTIDADE
   AND COALESCE(HF.HORARIOTRABALHO, F.HORARIOTRABALHO) = HOR.HORARIOTRABALHO
  WHERE ((F.SITUACAO <> 3) OR (F.SITUACAO = 3 AND F.DATASITUACAO >= ${db.aise.schema}.INICIOCOMPETENCIA(:exercicio,01)))
    AND NOT EXISTS ( 
            SELECT MP.MATRICULA
              FROM ${db.aise.schema}.RHMOVIMENTACAOPESSOAL MP
             WHERE MP.MATRICULA = F.MATRICULA
               AND MP.ENTIDADE = F.ENTIDADE
               AND MP.TIPOMOVIMENTACAO IN (39, 67)
         )
    AND EXTRACT(YEAR FROM F.DATAADMISSAO) <= :exercicio
  AND :exercicio >= :exibirapartirde) XX
  WHERE ((XX.ENTIDADE = :entidade) OR (:unificadados = 'S'))