SELECT F.ENTIDADE, F.FUNCAO, F.DESCRICAO, F.TIPOREMUNERACAO,
       COALESCE(F.VAGAS, 0) VAGAS, COALESCE(F.OCUPADAS, 0) OCUPADAS, COALESCE(GOF.VALOR, 0) VALOR
  FROM ${db.aise.schema}.RHFUNCAO F
  LEFT OUTER JOIN ${db.aise.schema}.RHGRUPOOCUPACIONALFAIXA GOF
    ON F.ENTIDADE = GOF.ENTIDADE
   AND F.QUADROSALARIAL = GOF.QUADROSALARIAL
   AND F.GRUPOOCUPACIONAL = GOF.GRUPOOCUPACIONAL
   AND F.NIVEL = GOF.NIVEL
   AND F.FAIXA = GOF.FAIXA
   AND GOF.INICIOVALIDADE <= ${db.aise.schema}.FIMCOMPETENCIA(:exercicio, 12)
 WHERE F.ENTIDADE = :entidade
   AND EXTRACT(YEAR FROM F.DATACADASTRO) <= :exercicio
   AND ((F.VIGENTE = 'S') OR (EXTRACT(YEAR FROM F.DATAALTERACAO) >= :exercicio))
   AND ((GOF.ENTIDADE IS NULL) OR
        (GOF.INICIOVALIDADE = (SELECT MAX(GOFX.INICIOVALIDADE)
                                FROM ${db.aise.schema}.RHGRUPOOCUPACIONALFAIXA GOFX
                                JOIN ${db.aise.schema}.RHGRUPOOCUPACIONALCOMPETENCIA GOC
                                  ON GOFX.ENTIDADE = GOC.ENTIDADE
                                 AND GOFX.QUADROSALARIAL = GOC.QUADROSALARIAL
                                 AND GOFX.GRUPOOCUPACIONAL = GOC.GRUPOOCUPACIONAL
                                 AND GOFX.NIVEL = GOC.NIVEL
                                 AND GOFX.INICIOVALIDADE = GOC.INICIOVALIDADE                                 
                               WHERE GOFX.ENTIDADE = GOF.ENTIDADE
                                 AND GOFX.QUADROSALARIAL = GOF.QUADROSALARIAL
                                 AND GOFX.GRUPOOCUPACIONAL = GOF.GRUPOOCUPACIONAL
                                 AND GOFX.NIVEL = GOF.NIVEL
                                 AND GOFX.FAIXA = GOF.FAIXA
                                 AND GOFX.INICIOVALIDADE <= ${db.aise.schema}.FIMCOMPETENCIA(:exercicio, 12)
                                 AND ((GOC.SITUACAO = 1) 
                                  OR  (NOT EXISTS (SELECT 1
                                                     FROM ${db.aise.schema}.RHGRUPOOCUPACIONALCOMPETENCIA GOCX
                                                    WHERE GOCX.ENTIDADE = GOC.ENTIDADE
                                                      AND GOCX.QUADROSALARIAL = GOC.QUADROSALARIAL
                                                      AND GOCX.GRUPOOCUPACIONAL = GOC.GRUPOOCUPACIONAL
                                                      AND GOCX.NIVEL = GOC.NIVEL
                                                      AND GOCX.INICIOVALIDADE = GOC.INICIOVALIDADE
                                                      AND GOCX.SITUACAO = 1))))))