/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.mapper;

import br.com.elotech.portaltransparencia.contabportal.domain.Empenho;
import br.com.elotech.portaltransparencia.contabportal.domain.FichaEmpenho;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhosListaDTO;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Function;

public class EmpenhoToDTO
implements Function<Empenho, EmpenhosListaDTO> {
    @Override
    public EmpenhosListaDTO apply(Empenho empenho) {
        EmpenhosListaDTO empDto = new EmpenhosListaDTO();
        empDto.setEntidade(empenho.getId().getEntidade());
        empDto.setExercicio(empenho.getId().getExercicio());
        empDto.setEmpenho(empenho.getId().getEmpenho());
        empDto.setEmpenhoExercicio(empenho.getId().getEmpenho() + "/" + empenho.getId().getExercicio());
        empDto.setData(empenho.getData());
        Optional.ofNullable(empenho.getFornecedor()).ifPresent(fornecedor -> {
            empDto.setFornecedor(fornecedor.getId());
            if (fornecedor.getTipoPessoa().equals("J")) {
                empDto.setNome(MaskFormatterUtils.getMaskFormatado((String)fornecedor.getCnpj(), (String)"##.###.###/####-##") + " - " + fornecedor.getNome());
            } else {
                empDto.setNome("****" + fornecedor.getCnpj().substring(4, 7) + "**** - " + fornecedor.getNome());
            }
        });
        empDto.setHistorico(empenho.getHistorico());
        empDto.setValorEmpenhado(this.getValorEmpenhado(empenho));
        empDto.setValorAnulado(this.getValorAnulado(empenho));
        empDto.setValorLiquidado(this.getValorLiquidado(empenho));
        empDto.setValorRetido(this.getValorRetido(empenho));
        empDto.setValorPago(this.getValorPago(empenho));
        empDto.setValorAPagar(this.getValorAPagar(empenho));
        return empDto;
    }

    public BigDecimal getValorEmpenhado(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorAnulado(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::calcularValorAnulado).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorLiquidado(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::calcularValorLiquidado).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorRetido(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::getValorRetencoes).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorPago(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::calcularValorPago).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorAPagar(Empenho empenho) {
        return empenho.getFichasEmpenho().stream().map(FichaEmpenho::calcularValorAPagar).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

