/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DiariaPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.TipoObjetivoDiariaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.ParametroEnum;
import br.com.elotech.portaltransparencia.contabportal.repository.DiariaRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.ParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DiariaRepositoryImpl
implements DiariaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiariaRepositoryImpl.class);
    private static final String AND_ASSINATURA = " AND ((DI.IDTIPOSITUACAO = 3) OR DI.IDSITUACAOASSINATURAELETRONICA IS NULL) ";
    private static final String DIARIAS = "db/sql/contab/diarias.sql";
    private static final String OBJETIVO_DIARIAS = "db/sql/contab/tipo-objetivo-diarias.sql";
    private static final String DIARIAS_COUNT = "db/sql/contab/diarias_count.sql";
    private static final String DIARIAS_ARQUIVOS = "db/sql/contab/diarias-arquivos.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final ParametroRepository parametroRepository;
    private final EntidadeContabilidadeService entidadeService;

    @Autowired
    public DiariaRepositoryImpl(ParametroRepository parametroRepository, DatasourceWrapper datasourceWrapper, EntidadeContabilidadeService entidadeService) {
        this.datasourceWrapper = datasourceWrapper;
        this.parametroRepository = parametroRepository;
        this.entidadeService = entidadeService;
    }

    public List<DiariaPessoalDTO> findDiariasWithoutQuantidade(FindPessoalParams params) {
        StringBuilder sql = this.filtrosDiarias(params, FileUtils.readResourceAsString((String)DIARIAS));
        if (this.utilizaAssinaturaEletronicaDiaria(params)) {
            sql.append(AND_ASSINATURA);
        }
        sql.append(" AND COALESCE(DI.QUANTIDADEDIARIAS,0) <= 0 ");
        sql.append(" order by DI.DATASAIDA desc ");
        this.consoleLogger(params, sql.toString());
        List diarias = this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(DiariaPessoalDTO.class));
        for (DiariaPessoalDTO diaria : diarias) {
            diaria.setDisplayEmpenho(String.format("%d/%d", diaria.getEmpenho(), diaria.getExercicio()));
        }
        return diarias;
    }

    public Page<DiariaPessoalDTO> findDiarias(FindPessoalParams params, Pageable pageable) {
        StringBuilder sql = this.filtrosDiarias(params, FileUtils.readResourceAsString((String)DIARIAS));
        if (this.utilizaAssinaturaEletronicaDiaria(params)) {
            sql.append(AND_ASSINATURA);
        }
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)" order by DI.DATASAIDA desc ");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        this.consoleLogger(params, query);
        List diarias = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(DiariaPessoalDTO.class));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        for (DiariaPessoalDTO diaria : diarias) {
            diaria.setDisplayEmpenho(String.format("%d/%d", diaria.getEmpenho(), diaria.getExercicio()));
            if (Objects.nonNull(diaria.getDataSaida())) {
                diaria.setDisplayDataSaida(diaria.getDataSaida().format(formatter));
            }
            if (Objects.nonNull(diaria.getDataRetorno())) {
                diaria.setDisplayDataRetorno(diaria.getDataRetorno().format(formatter));
            }
            diaria.setDisplayDataSaidaRetorno(String.format("%s - %s", diaria.getDisplayDataSaida(), diaria.getDisplayDataRetorno()));
            if (!Objects.nonNull(diaria.getQuantidadeDiarias())) continue;
            if (!diaria.getQuantidadeDiarias().equals(BigDecimal.ZERO)) {
                diaria.setValorUnitario(diaria.getValorDiarias().divide(diaria.getQuantidadeDiarias(), 6));
                continue;
            }
            diaria.setValorUnitario(BigDecimal.ZERO);
        }
        StringBuilder queryCount = this.filtrosDiarias(params, FileUtils.readResourceAsString((String)DIARIAS_COUNT));
        if (this.utilizaAssinaturaEletronicaDiaria(params)) {
            queryCount.append(" AND ((SAE.IDTIPOSITUACAO = 3) OR DI.IDSITUACAOASSINATURAELETRONICA IS NULL) ");
        }
        MapSqlParameterSource parameter = params.toJdbcParameter();
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
        return new PageImpl(diarias, pageable, total.longValue());
    }

    private void consoleLogger(FindPessoalParams params, String query) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query);
            LOGGER.debug(params.toString());
        }
    }

    public DiariaPessoalDTO findTotalDiarias(FindPessoalParams params) {
        String sql = FileUtils.readResourceAsString((String)DIARIAS);
        StringBuilder query = new StringBuilder();
        query.append("SELECT COALESCE(SUM(X.QUANTIDADEDIARIAS), 0) AS QUANTIDADEDIARIAS,");
        query.append("       COALESCE(SUM(X.VALORDIARIAS), 0.0) AS VALORDIARIAS,");
        query.append("       COALESCE(SUM(X.VALORANULADO), 0.0) AS VALORANULADO,");
        query.append("       COALESCE(SUM(X.VALOREMPENHO), 0.0) AS VALOREMPENHO");
        query.append(" FROM(   ");
        query.append(sql);
        query = this.filtrosDiarias(params, query.toString());
        if (this.utilizaAssinaturaEletronicaDiaria(params)) {
            query.append(AND_ASSINATURA);
        }
        query.append(") X ");
        this.consoleLogger(params, query.toString());
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(DiariaPessoalDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)rowMapper).stream().findFirst().orElse(new DiariaPessoalDTO());
    }

    private StringBuilder filtrosDiarias(FindPessoalParams params, String sql) {
        StringBuilder query = new StringBuilder(sql);
        params.getNome().ifPresent(item -> query.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(NOME)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER(:nome)) "));
        params.getDataInicial().ifPresent(item -> query.append(" AND CAST(DI.DATASAIDA AS DATE) >= :dataInicial "));
        params.getDataFinal().ifPresent(item -> query.append(" AND CAST(DI.DATASAIDA AS DATE) <= :dataFinal "));
        params.getDestino().ifPresent(item -> query.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(DI.DESTINO)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER(:destino)) "));
        params.getIdTipoObjetivoDiaria().ifPresent(item -> query.append(" AND DI.IDTIPOOBJETIVODIARIA = :idTipoObjetivoDiaria "));
        query.append(" AND DI.ENTIDADE " + this.entidadeService.resolveWhereSQL(params.getEntidade()));
        return query;
    }

    public Optional<DiariaPessoalDTO> findDiaria(FindPessoalParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)DIARIAS));
        query.append(" AND DI.UNIDADEORCAMENTARIA = :unidadeOrcamentaria ");
        query.append(" AND DI.EMPENHO = :empenho ");
        query.append(" AND DI.NUMEROLIQUIDACAO = :noLiquidacao ");
        query.append(" AND DI.ENTIDADE" + this.entidadeService.resolveWhereSQL(params.getEntidade()));
        if (this.utilizaAssinaturaEletronicaDiaria(params)) {
            query.append(AND_ASSINATURA);
        }
        this.consoleLogger(params, query.toString());
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(DiariaPessoalDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)rowMapper).stream().findFirst();
    }

    public List<ArquivoPessoalDTO> findArquivos(FindPessoalParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)DIARIAS_ARQUIVOS).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoPessoalDTO.class));
    }

    public List<TipoObjetivoDiariaDTO> getTiposObjetivoDiaria() {
        String sql = FileUtils.readResourceAsString((String)OBJETIVO_DIARIAS);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(TipoObjetivoDiariaDTO.class));
    }

    public boolean utilizaAssinaturaEletronicaDiaria(FindPessoalParams params) {
        Parametro assinaEletDiaria = this.parametroRepository.findByEntidadeExercicioModuloAndCodigo(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_UTILIZA_ASSINATURA_ELETRONICA_DIARIAS.getCodigo());
        if (!assinaEletDiaria.getValor().isEmpty()) {
            return SimNao.toBoolean((String)assinaEletDiaria.getValor());
        }
        return false;
    }
}

