/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.DiariaFeignClient;
import br.com.elotech.contabilidade.client.dto.DiariaMovimentacaoDTO;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AdiantamentoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.AdiantamentoService;
import br.com.elotech.portaltransparencia.contabportal.utils.DiariaOxyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class AdiantamentoOxyService
implements AdiantamentoService {
    private final DiariaFeignClient diariaFeignClient;
    private static final String ADIANTAMENTO = "2";

    public Page<AdiantamentoPessoalDTO> findAdiantamentos(FindPessoalParams findPessoalParams, Pageable pageable) {
        EloPage adiantamentos = this.diariaFeignClient.findDiarias(DiariaOxyUtils.buildSearch((FindPessoalParams)findPessoalParams, (String)";", (String)ADIANTAMENTO), DiariaOxyUtils.buildSort((Pageable)pageable));
        ArrayList adiantamentoPessoal = new ArrayList();
        adiantamentos.getContent().forEach(adiantamento -> adiantamentoPessoal.add(new AdiantamentoPessoalDTO(adiantamento)));
        return new PageImpl(adiantamentoPessoal, pageable, adiantamentos.getTotalElements());
    }

    public AdiantamentoPessoalDTO findTotalAdiantamentos(FindPessoalParams findPessoalParams) {
        return new AdiantamentoPessoalDTO();
    }

    public Optional<AdiantamentoPessoalDTO> findAdiantamento(FindPessoalParams findPessoalParams) {
        DiariaMovimentacaoDTO adiantamento = this.diariaFeignClient.findDetalhesDiaria(findPessoalParams.getEmpenho(), findPessoalParams.getExercicio(), findPessoalParams.getEntidade());
        AdiantamentoPessoalDTO adiantamentoPessoal = new AdiantamentoPessoalDTO(adiantamento);
        return Optional.of(adiantamentoPessoal);
    }

    public Optional<AdiantamentoPessoalDTO> findPrestacaoContas(FindPessoalParams findPessoalParams) {
        return Optional.empty();
    }

    public List<ArquivoPessoalDTO> findArquivos(FindPessoalParams findPessoalParams) {
        return new ArrayList<ArquivoPessoalDTO>();
    }

    @Generated
    public AdiantamentoOxyService(DiariaFeignClient diariaFeignClient) {
        this.diariaFeignClient = diariaFeignClient;
    }
}

