SELECT S.ENTIDADE,
       S.EXERCICIO,
       S.SUBVENCAO,
       S.ANOSUBVENCAO,
	   S.NUMEROSIT,
       S.TERMO,
       S.LEIAUTORIZATORIA,
	   S.IDTIPO,
       TS.DESCRICAO AS TIPOSUBVENCAO,
       S.ENTIDADEBENEFICIARIA,
       S.NOMEBENEFICIARIO,
       CASE WHEN F.TIPOPESSOA = 'F' THEN SUBSTR(F.CNPJ,1,3) || '.' || SUBSTR(F.CNPJ, 4, 3) || '.' || SUBSTR(F.CNPJ, 7, 3) || '-' || SUBSTR(F.CNPJ, 10, 2)
		    ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2)
	   END AS CNPJ,
       S.TIPOENTIDADE,
       S.OBJETO,
       S.UNIDADEMEDIDA,
       S.PERIODICIDADEPRESTACAO,
       S.DATATLIMITE,
       S.DATAINICIOCONVENIO,
       S.DATAVENCIMENTOCONVENIO,
       S.ARTIGOLOA,
       S.NRQTDPREVISTA,
       COALESCE(S.VALORPRESTADOEXERCANT, 0) AS VALORPRESTADOEXERCANT,
       COALESCE(S.VALORPREVISTO, 0) AS VALORPREVISTO,
       COALESCE(S.VALORCONTRAPARTIDA, 0) AS VALORCONTRAPARTIDA,
       S.DATACELEBRACAO,
       S.DATAPRAZOFINAL,
       S.VEICULOPUBLICACAO,
       S.DATAPUBLICACAO,
       S.NREDICAOPUBLICACAO,
       S.CONTADEBITO,
       S.CONTACREDITO,
       S.ANOLEIAUTORIZATORIA,
       S.PROGRAMATICA,
       S.FONTERECURSO,
       COALESCE((SELECT SUM(VALORPAGAMENTO - VALORESTPAGAMENTO + VALORRETENCOES)
          FROM ${db.contabilidade.schema}.EMPENHO
         WHERE ENTIDADE     = S.ENTIDADE
           AND EXERCICIO    = S.EXERCICIO
           AND SUBVENCAO    = S.SUBVENCAO
           AND ANOSUBVENCAO = S.ANOSUBVENCAO),0) AS VALORLIBERADO,
       COALESCE(S.VALORPREVISTO - (SELECT SUM(VALORPAGAMENTO - VALORESTPAGAMENTO + VALORRETENCOES)
                                     FROM ${db.contabilidade.schema}.EMPENHO
                                    WHERE ENTIDADE     = S.ENTIDADE
                                      AND EXERCICIO    = S.EXERCICIO
                                      AND SUBVENCAO    = S.SUBVENCAO
                                      AND ANOSUBVENCAO = S.ANOSUBVENCAO), 0) AS SALDO,
      (SELECT DISTINCT D.DESCRICAO
         FROM ${db.contabilidade.schema}.DESPESA D,
              ${db.contabilidade.schema}.NIVEISMODELODESPESA N
        WHERE CAST(SUBSTR(D.PROGRAMATICA, N.POSICAO, N.TAMANHO) AS VARCHAR(80)) = S.ORGAO
          AND D.ENTIDADE      = S.ENTIDADE
          AND D.EXERCICIO     = S.EXERCICIO
          AND D.MODELODESPESA = N.MODELODESPESA
          AND D.TIPO          = N.TIPO
          AND D.NIVEL         = N.ORDEM
          AND N.NIVELLEI      = 'O') ORGAO,
       COALESCE((SELECT SUM(VALOR)
                   FROM ${db.contabilidade.schema}.SUBVENCAOADITIVO SA
                  WHERE SA.ENTIDADE     = S.ENTIDADE
                    AND SA.EXERCICIO    = S.EXERCICIO 
                    AND SA.SUBVENCAO    = S.SUBVENCAO 
                    AND SA.ANOSUBVENCAO = S.ANOSUBVENCAO),0) AS VALORADITIVO,
       COALESCE((SELECT MAX(DATAFIMVIGENCIA)
                   FROM ${db.contabilidade.schema}.SUBVENCAOADITIVO SA
                  WHERE SA.ENTIDADE     = S.ENTIDADE
                    AND SA.EXERCICIO    = S.EXERCICIO 
                    AND SA.SUBVENCAO    = S.SUBVENCAO 
                    AND SA.ANOSUBVENCAO = S.ANOSUBVENCAO), DATAVENCIMENTOCONVENIO) AS DATATERMINO
  FROM ${db.contabilidade.schema}.SUBVENCAOSOCIAL S
  JOIN ${db.contabilidade.schema}.TIPOSUBVENCAO TS
    ON TS.ID = S.IDTIPO
  LEFT JOIN ${db.contabilidade.schema}.FORNECEDOR F
    ON F.FORNECEDOR = S.ENTIDADEBENEFICIARIA
 WHERE S.ENTIDADE  = :entidade