SELECT G.ID, 
       G.DESCRICAO, 
       G.MOSTRAWEB, 
       G.FILTRARPOREXERCICIO,
       SG.ID AS IDSUBGRUPO,
       SGE.ID AS IDSUBGRUPOEXERCICIO,
       SG.DESCRICAO AS DESCRICAOSUBGRUPO,
       PUB.ID AS IDPUBLICACAO,
       PUB.DESCRICAO AS DESCRICAOPUBLICACAO,
       PUB.NOMEARQUIVO,
       PUB.PERIODO,
       PUB.TIPOPERIODO,
       PUB.RESUMO,
       ARQ.IDARQUIVO,
       PUB.LINKARQUIVO AS LINK,
       LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO,
       ARQ.DATAARQUIVO
 FROM ${db.contabilidade.schema}.ELOPORTALGRUPOPUBLICACAO G
 
 LEFT OUTER JOIN ${db.contabilidade.schema}.ELOPORTALSUBGRUPOPUBLICACAO SG ON
     G.ID = SG.IDGRUPOPUBLICACAO
	 
 LEFT OUTER JOIN ${db.contabilidade.schema}.ELOPORTALSUBGRUPOEXERCICIO SGE ON
     SG.ID = SGE.IDSUBGRUPOPUBLICACAO
     AND SGE.ENTIDADE = :entidade
     AND ((G.FILTRARPOREXERCICIO = 'S' AND SGE.EXERCICIO = :exercicio) OR (G.FILTRARPOREXERCICIO = 'N'))
     AND SGE.MOSTRAWEB = 'S'
	 
 LEFT OUTER JOIN ${db.contabilidade.schema}.ELOPORTALPUBLICACAO PUB ON
     PUB.IDSUBGRUPOEXERCICIO = SGE.ID
     AND PUB.ENTIDADE = :entidade
     AND ((G.FILTRARPOREXERCICIO = 'S' AND PUB.EXERCICIO = :exercicio) OR (G.FILTRARPOREXERCICIO = 'N'))
	 
 LEFT OUTER JOIN ${db.contabilidade.schema}.ARQUIVO ARQ
 	ON ARQ.ID = PUB.IDARQUIVO
	
 LEFT OUTER JOIN schema_eloarquivo.ARQUIVO_CONTENT AC
    ON ARQ.ID =  AC.ID
	
 LEFT OUTER JOIN ${db.contabilidade.schema}.ELOPORTALGRUPOPUBLENTIDADE GPE
    ON GPE.ENTIDADE = :entidade
    AND GPE.IDGRUPO = G.ID
	
 WHERE GPE.MOSTRAWEB = 'S' 
 $[filtroTipoPublicacao]
 ORDER BY G.DESCRICAO, SG.ORDEM, IDSUBGRUPO, COALESCE(PUB.ORDEM,0)
