/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.saude.service;

import br.com.elotech.portaltransparencia.saude.domain.dto.FilaEsperaDTO;
import br.com.elotech.portaltransparencia.saude.domain.dto.PacienteFilaEsperaDTO;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class FilaEsperaService {
    private final RestTemplate restTemplate;
    @Value(value="${elotech.sistemaSaude.url:}")
    private String urlSaude;
    @Value(value="${elotech.sistemaSaude.enabled:false}")
    private Boolean sistemaSaude;

    public FilaEsperaService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public List<FilaEsperaDTO> findFilasEpera() {
        if (Boolean.FALSE.equals(this.sistemaSaude) || this.urlSaude.isEmpty()) {
            return new ArrayList<FilaEsperaDTO>();
        }
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/filadeespera/", this.urlSaude));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, FilaEsperaDTO[].class);
            return Arrays.asList((FilaEsperaDTO[])responseEntity.getBody());
        }
        catch (HttpClientErrorException e) {
            return new ArrayList<FilaEsperaDTO>();
        }
    }

    public List<FilaEsperaDTO> findFilasEperaCns(String cns) {
        if (Boolean.FALSE.equals(this.sistemaSaude) || this.urlSaude.isEmpty()) {
            return new ArrayList<FilaEsperaDTO>();
        }
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/filadeespera/usuariocns/%s", this.urlSaude, cns));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, FilaEsperaDTO[].class);
            return Arrays.asList((FilaEsperaDTO[])responseEntity.getBody());
        }
        catch (HttpClientErrorException e) {
            return new ArrayList<FilaEsperaDTO>();
        }
    }

    public List<PacienteFilaEsperaDTO> findPacientesDaFila(Long id) {
        if (Boolean.FALSE.equals(this.sistemaSaude) || this.urlSaude.isEmpty()) {
            return new ArrayList<PacienteFilaEsperaDTO>();
        }
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/filadeespera/%d", this.urlSaude, id));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, PacienteFilaEsperaDTO[].class);
            return Arrays.asList((PacienteFilaEsperaDTO[])responseEntity.getBody());
        }
        catch (HttpClientErrorException e) {
            return new ArrayList<PacienteFilaEsperaDTO>();
        }
    }
}

