SELECT A.ENTIDADE,
       A.EXERCICIO,
       A.CONTA,
       COALESCE(D.DESCRICAO, F.DESCRICAO) as DESCRICAO,
       D.IDCONTACORRENTE,
       ABS(SUM(CASE C.DEBCRED WHEN 'D' THEN C.VALOR ELSE C.VALOR * -1 END)) AS VALORLANCADO,
       A.TIPO
  FROM ${db.contabilidade.schema}.ELOPORTALREPASSES A
  LEFT OUTER JOIN ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA C
    ON C.ENTIDADE = A.ENTIDADE 
   AND C.EXERCICIO = A.EXERCICIO 
   AND C.CONTA = A.CONTA 
  LEFT OUTER JOIN ${db.contabilidade.schema}.PLANO F
    ON F.ENTIDADE = A.ENTIDADE 
   AND F.EXERCICIO = A.EXERCICIO 
   AND F.CONTA = A.CONTA 
  LEFT OUTER JOIN ${db.contabilidade.schema}.EVENTOSLANCADOS B
    ON B.ENTIDADE = C.ENTIDADE 
   AND B.EXERCICIO = C.EXERCICIO 
   AND B.TIPOEVENTO = C.TIPOEVENTO 
   AND B.GRUPOEVENTO = C.GRUPOEVENTO 
   AND B.EVENTO = C.EVENTO 
   AND B.NROLANCAMENTO = C.NROLANCAMENTO 
  LEFT OUTER JOIN ${db.contabilidade.schema}.CONTACORRENTE D
    ON D.ENTIDADE = C.ENTIDADE 
   AND D.IDCONTACORRENTE = C.IDCONTACORRENTE 
 WHERE A.ENTIDADE = :entidade
   AND A.EXERCICIO = :exercicio
   AND A.TIPO  = :tipo
   AND C.GRUPOEVENTO NOT IN (80,81,85,86) 
 GROUP BY  A.ENTIDADE, A.EXERCICIO, A.CONTA, D.DESCRICAO, F.DESCRICAO, D.IDCONTACORRENTE, A.TIPO
 ORDER BY COALESCE(D.DESCRICAO, F.DESCRICAO)
 