/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Exercicio;
import br.com.elotech.portaltransparencia.contabportal.domain.ExercicioPK;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.QExercicio;
import br.com.elotech.portaltransparencia.contabportal.repository.ExercicioRepository;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ExercicioService {
    private static final Long ANOFINAL = 9999L;
    private final ExercicioRepository exercicioRepository;
    private final EntidadeContabilidadeService entidadeService;
    private final PortalParametroRepository portalParametroRepository;

    public ExercicioService(ExercicioRepository exercicioRepository, EntidadeContabilidadeService entidadeService, PortalParametroRepository portalParametroRepository) {
        this.exercicioRepository = exercicioRepository;
        this.entidadeService = entidadeService;
        this.portalParametroRepository = portalParametroRepository;
    }

    public List<Exercicio> getExercicios(Long idEntidade) {
        Entidade entidade = this.entidadeService.getEntidadeSelecionada(idEntidade);
        Long anoInicial = 0L;
        Long anoFinal = ANOFINAL;
        PortalParametroContabil paramAnoInicial = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade.getId(), Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ANO_INICIAL);
        PortalParametroContabil paramAnoFinal = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade.getId(), Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ANO_FINAL);
        if (paramAnoInicial != null && paramAnoInicial.isConfigurado().booleanValue()) {
            anoInicial = Long.parseLong(paramAnoInicial.getValor());
        }
        if (paramAnoFinal != null && paramAnoFinal.isConfigurado().booleanValue()) {
            anoFinal = Long.parseLong(paramAnoFinal.getValor());
        }
        Iterable exerciciosIterable = this.exercicioRepository.findAll((Predicate)QExercicio.exercicio.id().entidade().eq((Object)entidade).and((Predicate)QExercicio.exercicio.id().exercicio.between((Number)anoInicial, (Number)anoFinal)), this.sortByIdDesc());
        return Lists.newArrayList((Iterable)exerciciosIterable);
    }

    private Sort sortByIdDesc() {
        return Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id.exercicio"});
    }

    public Optional<Exercicio> findExercicioPadrao() {
        Optional entidadePrincipal = this.entidadeService.getEntidadePrincipal();
        return this.getExercicios(((Entidade)entidadePrincipal.get()).getId()).stream().findFirst();
    }

    public Exercicio findOne(ExercicioPK pk) {
        return (Exercicio)this.exercicioRepository.findOne((Object)pk);
    }

    public Long findModeloDespesa(Long entidade, Long exercicio) {
        ExercicioPK exercicioPK = new ExercicioPK(Entidade.of((Long)entidade), exercicio);
        return ((Exercicio)this.exercicioRepository.findOne((Object)exercicioPK)).getModeloDespesa().getId();
    }
}

