/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.AnulacaoEmpenhoDTO;
import br.com.elotech.contabilidade.client.dto.CidadeDTO;
import br.com.elotech.contabilidade.client.dto.DiariaMovimentacaoDTO;
import br.com.elotech.contabilidade.client.dto.DotacaoDTO;
import br.com.elotech.contabilidade.client.dto.EmpenhoDTO;
import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.contabilidade.client.dto.LeisAtosDTO;
import br.com.elotech.contabilidade.client.dto.LiquidacaoDTO;
import br.com.elotech.contabilidade.client.dto.ObjetivoDiariaDTO;
import br.com.elotech.contabilidade.client.dto.PessoaDTO;
import br.com.elotech.contabilidade.client.dto.UnidadeDTO;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class DiariaPessoalDTO {
    private Long entidade;
    private Long exercicio;
    private Long empenho;
    private Long entidadeEmpenho;
    private Long exercicioEmpenho;
    private Long numeroLiquidacao;
    private String unidadeOrcamentaria;
    private String nome;
    private LocalDate dataSaida;
    private String destino;
    private LocalDate dataRetorno;
    private BigDecimal quantidadeDiarias;
    private BigDecimal valorDiarias;
    private String meioTransporte;
    private BigDecimal valorPassagem;
    private String motivo;
    private String cargo;
    private Long numeroProcesso;
    private Long anoProcesso;
    private String lotacao;
    private String horaSaida;
    private String horaRetorno;
    private BigDecimal valorEmpenho;
    private BigDecimal valorAnulado;
    private Long quantidadeAnulacoes;
    private String secretaria;
    private String matricula;
    private Long noAto;
    private LocalDate dataAto;
    private BigDecimal gastosTotais;
    private BigDecimal valorUnitario;
    private String displayEmpenho;
    private String displayDataSaidaRetorno;
    private String displayDataRetorno;
    private String displayDataSaida;
    private String labelCargo;
    private Long idTipoObjetivoDiaria;
    private String tipoObjetivoDiaria;
    private BigDecimal valorHospedagem;
    private BigDecimal valorEvento;

    public DiariaPessoalDTO(DiariaMovimentacaoDTO dto) {
        EmpenhoDTO empenhoDiaria = Optional.ofNullable(dto.getEmpenho()).orElse(new EmpenhoDTO());
        ExercicioDTO exercicioDiaria = Optional.ofNullable(dto.getExercicio()).orElse(new ExercicioDTO());
        DotacaoDTO dotacao = Optional.ofNullable(dto.getDotacao()).orElse(new DotacaoDTO());
        Long quantidade = Optional.ofNullable(dto.getQuantidadeDiaria()).orElse(0L);
        AnulacaoEmpenhoDTO anulacaoEmpenho = Optional.ofNullable(dto.getAnulacaoEmpenho()).orElse(new AnulacaoEmpenhoDTO());
        LeisAtosDTO leisAtos = Optional.ofNullable(dto.getLeiAutorizativa()).orElse(new LeisAtosDTO());
        PessoaDTO servidor = Optional.ofNullable(dto.getServidor()).orElse(new PessoaDTO());
        this.entidade = exercicioDiaria.getEntidade().getId();
        this.exercicio = exercicioDiaria.getExercicio();
        this.exercicioEmpenho = Optional.ofNullable(empenhoDiaria.getExercicio()).map(ExercicioDTO::getExercicio).orElse(null);
        this.entidadeEmpenho = Optional.ofNullable(empenhoDiaria.getExercicio()).map(ExercicioDTO::getEntidade).map(EntidadeDTO::getId).orElse(null);
        this.empenho = empenhoDiaria.getNumeroEmpenho();
        this.numeroLiquidacao = Optional.ofNullable(dto.getLiquidacao()).map(LiquidacaoDTO::getNumeroLiquidacao).orElse(null);
        this.unidadeOrcamentaria = Optional.ofNullable(dotacao.getUnidade()).map(UnidadeDTO::getUnidadeOrgaoValue).orElse("");
        this.dataSaida = dto.getDataInicio();
        this.destino = Optional.ofNullable(dto.getDestinoViagem()).map(CidadeDTO::getDescricao).orElse("");
        this.dataRetorno = dto.getDataFim();
        this.quantidadeDiarias = BigDecimal.valueOf(quantidade);
        this.valorDiarias = dto.getValorTotal();
        this.meioTransporte = dto.getMeioTransporte();
        this.valorPassagem = dto.getCustoTransporte();
        this.motivo = dto.getMotivoLiberacao();
        this.nome = servidor.getNome();
        this.cargo = servidor.getCargo();
        this.matricula = servidor.getMatricula();
        this.horaSaida = dto.getHoraSaida();
        this.valorEmpenho = empenhoDiaria.getValor();
        this.valorAnulado = anulacaoEmpenho.getValor();
        this.numeroProcesso = dto.getNumeroProcesso();
        this.anoProcesso = dto.getAnoProcesso();
        this.gastosTotais = dto.getValorTotal();
        this.secretaria = Optional.ofNullable(dotacao.getUnidade()).map(UnidadeDTO::getDescricao).orElse(null);
        this.noAto = leisAtos.getNumero();
        this.dataAto = leisAtos.getDataAto();
        this.valorUnitario = dto.getValorDiaria();
        this.valorHospedagem = dto.getValorHospedagem();
        this.valorEvento = dto.getValorEvento();
        this.horaRetorno = dto.getHoraRetorno();
        this.idTipoObjetivoDiaria = Optional.ofNullable(dto.getObjetivoDiaria()).map(ObjetivoDiariaDTO::getCodigo).orElse(null);
        this.tipoObjetivoDiaria = Optional.ofNullable(dto.getObjetivoDiaria()).map(ObjetivoDiariaDTO::getDescricao).orElse(null);
    }

    public String getSituacaoCancelamento() {
        if (Objects.isNull(this.getValorAnulado()) || BigDecimal.ZERO.equals(this.getValorAnulado())) {
            return "N\u00e3o cancelado";
        }
        BigDecimal valorCancelado = this.getValorEmpenho().subtract(this.getValorAnulado());
        if (BigDecimal.ZERO.equals(valorCancelado)) {
            return "Cancelado Totalmente";
        }
        return "Cancelado Parcialmente";
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getEmpenho() {
        return this.empenho;
    }

    @Generated
    public Long getEntidadeEmpenho() {
        return this.entidadeEmpenho;
    }

    @Generated
    public Long getExercicioEmpenho() {
        return this.exercicioEmpenho;
    }

    @Generated
    public Long getNumeroLiquidacao() {
        return this.numeroLiquidacao;
    }

    @Generated
    public String getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public LocalDate getDataSaida() {
        return this.dataSaida;
    }

    @Generated
    public String getDestino() {
        return this.destino;
    }

    @Generated
    public LocalDate getDataRetorno() {
        return this.dataRetorno;
    }

    @Generated
    public BigDecimal getQuantidadeDiarias() {
        return this.quantidadeDiarias;
    }

    @Generated
    public BigDecimal getValorDiarias() {
        return this.valorDiarias;
    }

    @Generated
    public String getMeioTransporte() {
        return this.meioTransporte;
    }

    @Generated
    public BigDecimal getValorPassagem() {
        return this.valorPassagem;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public String getCargo() {
        return this.cargo;
    }

    @Generated
    public Long getNumeroProcesso() {
        return this.numeroProcesso;
    }

    @Generated
    public Long getAnoProcesso() {
        return this.anoProcesso;
    }

    @Generated
    public String getLotacao() {
        return this.lotacao;
    }

    @Generated
    public String getHoraSaida() {
        return this.horaSaida;
    }

    @Generated
    public String getHoraRetorno() {
        return this.horaRetorno;
    }

    @Generated
    public BigDecimal getValorEmpenho() {
        return this.valorEmpenho;
    }

    @Generated
    public BigDecimal getValorAnulado() {
        return this.valorAnulado;
    }

    @Generated
    public Long getQuantidadeAnulacoes() {
        return this.quantidadeAnulacoes;
    }

    @Generated
    public String getSecretaria() {
        return this.secretaria;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public Long getNoAto() {
        return this.noAto;
    }

    @Generated
    public LocalDate getDataAto() {
        return this.dataAto;
    }

    @Generated
    public BigDecimal getGastosTotais() {
        return this.gastosTotais;
    }

    @Generated
    public BigDecimal getValorUnitario() {
        return this.valorUnitario;
    }

    @Generated
    public String getDisplayEmpenho() {
        return this.displayEmpenho;
    }

    @Generated
    public String getDisplayDataSaidaRetorno() {
        return this.displayDataSaidaRetorno;
    }

    @Generated
    public String getDisplayDataRetorno() {
        return this.displayDataRetorno;
    }

    @Generated
    public String getDisplayDataSaida() {
        return this.displayDataSaida;
    }

    @Generated
    public String getLabelCargo() {
        return this.labelCargo;
    }

    @Generated
    public Long getIdTipoObjetivoDiaria() {
        return this.idTipoObjetivoDiaria;
    }

    @Generated
    public String getTipoObjetivoDiaria() {
        return this.tipoObjetivoDiaria;
    }

    @Generated
    public BigDecimal getValorHospedagem() {
        return this.valorHospedagem;
    }

    @Generated
    public BigDecimal getValorEvento() {
        return this.valorEvento;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    @Generated
    public void setEntidadeEmpenho(Long entidadeEmpenho) {
        this.entidadeEmpenho = entidadeEmpenho;
    }

    @Generated
    public void setExercicioEmpenho(Long exercicioEmpenho) {
        this.exercicioEmpenho = exercicioEmpenho;
    }

    @Generated
    public void setNumeroLiquidacao(Long numeroLiquidacao) {
        this.numeroLiquidacao = numeroLiquidacao;
    }

    @Generated
    public void setUnidadeOrcamentaria(String unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setDataSaida(LocalDate dataSaida) {
        this.dataSaida = dataSaida;
    }

    @Generated
    public void setDestino(String destino) {
        this.destino = destino;
    }

    @Generated
    public void setDataRetorno(LocalDate dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    @Generated
    public void setQuantidadeDiarias(BigDecimal quantidadeDiarias) {
        this.quantidadeDiarias = quantidadeDiarias;
    }

    @Generated
    public void setValorDiarias(BigDecimal valorDiarias) {
        this.valorDiarias = valorDiarias;
    }

    @Generated
    public void setMeioTransporte(String meioTransporte) {
        this.meioTransporte = meioTransporte;
    }

    @Generated
    public void setValorPassagem(BigDecimal valorPassagem) {
        this.valorPassagem = valorPassagem;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    @Generated
    public void setNumeroProcesso(Long numeroProcesso) {
        this.numeroProcesso = numeroProcesso;
    }

    @Generated
    public void setAnoProcesso(Long anoProcesso) {
        this.anoProcesso = anoProcesso;
    }

    @Generated
    public void setLotacao(String lotacao) {
        this.lotacao = lotacao;
    }

    @Generated
    public void setHoraSaida(String horaSaida) {
        this.horaSaida = horaSaida;
    }

    @Generated
    public void setHoraRetorno(String horaRetorno) {
        this.horaRetorno = horaRetorno;
    }

    @Generated
    public void setValorEmpenho(BigDecimal valorEmpenho) {
        this.valorEmpenho = valorEmpenho;
    }

    @Generated
    public void setValorAnulado(BigDecimal valorAnulado) {
        this.valorAnulado = valorAnulado;
    }

    @Generated
    public void setQuantidadeAnulacoes(Long quantidadeAnulacoes) {
        this.quantidadeAnulacoes = quantidadeAnulacoes;
    }

    @Generated
    public void setSecretaria(String secretaria) {
        this.secretaria = secretaria;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setNoAto(Long noAto) {
        this.noAto = noAto;
    }

    @Generated
    public void setDataAto(LocalDate dataAto) {
        this.dataAto = dataAto;
    }

    @Generated
    public void setGastosTotais(BigDecimal gastosTotais) {
        this.gastosTotais = gastosTotais;
    }

    @Generated
    public void setValorUnitario(BigDecimal valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    @Generated
    public void setDisplayEmpenho(String displayEmpenho) {
        this.displayEmpenho = displayEmpenho;
    }

    @Generated
    public void setDisplayDataSaidaRetorno(String displayDataSaidaRetorno) {
        this.displayDataSaidaRetorno = displayDataSaidaRetorno;
    }

    @Generated
    public void setDisplayDataRetorno(String displayDataRetorno) {
        this.displayDataRetorno = displayDataRetorno;
    }

    @Generated
    public void setDisplayDataSaida(String displayDataSaida) {
        this.displayDataSaida = displayDataSaida;
    }

    @Generated
    public void setLabelCargo(String labelCargo) {
        this.labelCargo = labelCargo;
    }

    @Generated
    public void setIdTipoObjetivoDiaria(Long idTipoObjetivoDiaria) {
        this.idTipoObjetivoDiaria = idTipoObjetivoDiaria;
    }

    @Generated
    public void setTipoObjetivoDiaria(String tipoObjetivoDiaria) {
        this.tipoObjetivoDiaria = tipoObjetivoDiaria;
    }

    @Generated
    public void setValorHospedagem(BigDecimal valorHospedagem) {
        this.valorHospedagem = valorHospedagem;
    }

    @Generated
    public void setValorEvento(BigDecimal valorEvento) {
        this.valorEvento = valorEvento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiariaPessoalDTO)) {
            return false;
        }
        DiariaPessoalDTO other = (DiariaPessoalDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$empenho = this.getEmpenho();
        Long other$empenho = other.getEmpenho();
        if (this$empenho == null ? other$empenho != null : !((Object)this$empenho).equals(other$empenho)) {
            return false;
        }
        Long this$entidadeEmpenho = this.getEntidadeEmpenho();
        Long other$entidadeEmpenho = other.getEntidadeEmpenho();
        if (this$entidadeEmpenho == null ? other$entidadeEmpenho != null : !((Object)this$entidadeEmpenho).equals(other$entidadeEmpenho)) {
            return false;
        }
        Long this$exercicioEmpenho = this.getExercicioEmpenho();
        Long other$exercicioEmpenho = other.getExercicioEmpenho();
        if (this$exercicioEmpenho == null ? other$exercicioEmpenho != null : !((Object)this$exercicioEmpenho).equals(other$exercicioEmpenho)) {
            return false;
        }
        Long this$numeroLiquidacao = this.getNumeroLiquidacao();
        Long other$numeroLiquidacao = other.getNumeroLiquidacao();
        if (this$numeroLiquidacao == null ? other$numeroLiquidacao != null : !((Object)this$numeroLiquidacao).equals(other$numeroLiquidacao)) {
            return false;
        }
        String this$unidadeOrcamentaria = this.getUnidadeOrcamentaria();
        String other$unidadeOrcamentaria = other.getUnidadeOrcamentaria();
        if (this$unidadeOrcamentaria == null ? other$unidadeOrcamentaria != null : !this$unidadeOrcamentaria.equals(other$unidadeOrcamentaria)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        LocalDate this$dataSaida = this.getDataSaida();
        LocalDate other$dataSaida = other.getDataSaida();
        if (this$dataSaida == null ? other$dataSaida != null : !((Object)this$dataSaida).equals(other$dataSaida)) {
            return false;
        }
        String this$destino = this.getDestino();
        String other$destino = other.getDestino();
        if (this$destino == null ? other$destino != null : !this$destino.equals(other$destino)) {
            return false;
        }
        LocalDate this$dataRetorno = this.getDataRetorno();
        LocalDate other$dataRetorno = other.getDataRetorno();
        if (this$dataRetorno == null ? other$dataRetorno != null : !((Object)this$dataRetorno).equals(other$dataRetorno)) {
            return false;
        }
        BigDecimal this$quantidadeDiarias = this.getQuantidadeDiarias();
        BigDecimal other$quantidadeDiarias = other.getQuantidadeDiarias();
        if (this$quantidadeDiarias == null ? other$quantidadeDiarias != null : !((Object)this$quantidadeDiarias).equals(other$quantidadeDiarias)) {
            return false;
        }
        BigDecimal this$valorDiarias = this.getValorDiarias();
        BigDecimal other$valorDiarias = other.getValorDiarias();
        if (this$valorDiarias == null ? other$valorDiarias != null : !((Object)this$valorDiarias).equals(other$valorDiarias)) {
            return false;
        }
        String this$meioTransporte = this.getMeioTransporte();
        String other$meioTransporte = other.getMeioTransporte();
        if (this$meioTransporte == null ? other$meioTransporte != null : !this$meioTransporte.equals(other$meioTransporte)) {
            return false;
        }
        BigDecimal this$valorPassagem = this.getValorPassagem();
        BigDecimal other$valorPassagem = other.getValorPassagem();
        if (this$valorPassagem == null ? other$valorPassagem != null : !((Object)this$valorPassagem).equals(other$valorPassagem)) {
            return false;
        }
        String this$motivo = this.getMotivo();
        String other$motivo = other.getMotivo();
        if (this$motivo == null ? other$motivo != null : !this$motivo.equals(other$motivo)) {
            return false;
        }
        String this$cargo = this.getCargo();
        String other$cargo = other.getCargo();
        if (this$cargo == null ? other$cargo != null : !this$cargo.equals(other$cargo)) {
            return false;
        }
        Long this$numeroProcesso = this.getNumeroProcesso();
        Long other$numeroProcesso = other.getNumeroProcesso();
        if (this$numeroProcesso == null ? other$numeroProcesso != null : !((Object)this$numeroProcesso).equals(other$numeroProcesso)) {
            return false;
        }
        Long this$anoProcesso = this.getAnoProcesso();
        Long other$anoProcesso = other.getAnoProcesso();
        if (this$anoProcesso == null ? other$anoProcesso != null : !((Object)this$anoProcesso).equals(other$anoProcesso)) {
            return false;
        }
        String this$lotacao = this.getLotacao();
        String other$lotacao = other.getLotacao();
        if (this$lotacao == null ? other$lotacao != null : !this$lotacao.equals(other$lotacao)) {
            return false;
        }
        String this$horaSaida = this.getHoraSaida();
        String other$horaSaida = other.getHoraSaida();
        if (this$horaSaida == null ? other$horaSaida != null : !this$horaSaida.equals(other$horaSaida)) {
            return false;
        }
        String this$horaRetorno = this.getHoraRetorno();
        String other$horaRetorno = other.getHoraRetorno();
        if (this$horaRetorno == null ? other$horaRetorno != null : !this$horaRetorno.equals(other$horaRetorno)) {
            return false;
        }
        BigDecimal this$valorEmpenho = this.getValorEmpenho();
        BigDecimal other$valorEmpenho = other.getValorEmpenho();
        if (this$valorEmpenho == null ? other$valorEmpenho != null : !((Object)this$valorEmpenho).equals(other$valorEmpenho)) {
            return false;
        }
        BigDecimal this$valorAnulado = this.getValorAnulado();
        BigDecimal other$valorAnulado = other.getValorAnulado();
        if (this$valorAnulado == null ? other$valorAnulado != null : !((Object)this$valorAnulado).equals(other$valorAnulado)) {
            return false;
        }
        Long this$quantidadeAnulacoes = this.getQuantidadeAnulacoes();
        Long other$quantidadeAnulacoes = other.getQuantidadeAnulacoes();
        if (this$quantidadeAnulacoes == null ? other$quantidadeAnulacoes != null : !((Object)this$quantidadeAnulacoes).equals(other$quantidadeAnulacoes)) {
            return false;
        }
        String this$secretaria = this.getSecretaria();
        String other$secretaria = other.getSecretaria();
        if (this$secretaria == null ? other$secretaria != null : !this$secretaria.equals(other$secretaria)) {
            return false;
        }
        String this$matricula = this.getMatricula();
        String other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !this$matricula.equals(other$matricula)) {
            return false;
        }
        Long this$noAto = this.getNoAto();
        Long other$noAto = other.getNoAto();
        if (this$noAto == null ? other$noAto != null : !((Object)this$noAto).equals(other$noAto)) {
            return false;
        }
        LocalDate this$dataAto = this.getDataAto();
        LocalDate other$dataAto = other.getDataAto();
        if (this$dataAto == null ? other$dataAto != null : !((Object)this$dataAto).equals(other$dataAto)) {
            return false;
        }
        BigDecimal this$gastosTotais = this.getGastosTotais();
        BigDecimal other$gastosTotais = other.getGastosTotais();
        if (this$gastosTotais == null ? other$gastosTotais != null : !((Object)this$gastosTotais).equals(other$gastosTotais)) {
            return false;
        }
        BigDecimal this$valorUnitario = this.getValorUnitario();
        BigDecimal other$valorUnitario = other.getValorUnitario();
        if (this$valorUnitario == null ? other$valorUnitario != null : !((Object)this$valorUnitario).equals(other$valorUnitario)) {
            return false;
        }
        String this$displayEmpenho = this.getDisplayEmpenho();
        String other$displayEmpenho = other.getDisplayEmpenho();
        if (this$displayEmpenho == null ? other$displayEmpenho != null : !this$displayEmpenho.equals(other$displayEmpenho)) {
            return false;
        }
        String this$displayDataSaidaRetorno = this.getDisplayDataSaidaRetorno();
        String other$displayDataSaidaRetorno = other.getDisplayDataSaidaRetorno();
        if (this$displayDataSaidaRetorno == null ? other$displayDataSaidaRetorno != null : !this$displayDataSaidaRetorno.equals(other$displayDataSaidaRetorno)) {
            return false;
        }
        String this$displayDataRetorno = this.getDisplayDataRetorno();
        String other$displayDataRetorno = other.getDisplayDataRetorno();
        if (this$displayDataRetorno == null ? other$displayDataRetorno != null : !this$displayDataRetorno.equals(other$displayDataRetorno)) {
            return false;
        }
        String this$displayDataSaida = this.getDisplayDataSaida();
        String other$displayDataSaida = other.getDisplayDataSaida();
        if (this$displayDataSaida == null ? other$displayDataSaida != null : !this$displayDataSaida.equals(other$displayDataSaida)) {
            return false;
        }
        String this$labelCargo = this.getLabelCargo();
        String other$labelCargo = other.getLabelCargo();
        if (this$labelCargo == null ? other$labelCargo != null : !this$labelCargo.equals(other$labelCargo)) {
            return false;
        }
        Long this$idTipoObjetivoDiaria = this.getIdTipoObjetivoDiaria();
        Long other$idTipoObjetivoDiaria = other.getIdTipoObjetivoDiaria();
        if (this$idTipoObjetivoDiaria == null ? other$idTipoObjetivoDiaria != null : !((Object)this$idTipoObjetivoDiaria).equals(other$idTipoObjetivoDiaria)) {
            return false;
        }
        String this$tipoObjetivoDiaria = this.getTipoObjetivoDiaria();
        String other$tipoObjetivoDiaria = other.getTipoObjetivoDiaria();
        if (this$tipoObjetivoDiaria == null ? other$tipoObjetivoDiaria != null : !this$tipoObjetivoDiaria.equals(other$tipoObjetivoDiaria)) {
            return false;
        }
        BigDecimal this$valorHospedagem = this.getValorHospedagem();
        BigDecimal other$valorHospedagem = other.getValorHospedagem();
        if (this$valorHospedagem == null ? other$valorHospedagem != null : !((Object)this$valorHospedagem).equals(other$valorHospedagem)) {
            return false;
        }
        BigDecimal this$valorEvento = this.getValorEvento();
        BigDecimal other$valorEvento = other.getValorEvento();
        return !(this$valorEvento == null ? other$valorEvento != null : !((Object)this$valorEvento).equals(other$valorEvento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DiariaPessoalDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $empenho = this.getEmpenho();
        result = result * 59 + ($empenho == null ? 43 : ((Object)$empenho).hashCode());
        Long $entidadeEmpenho = this.getEntidadeEmpenho();
        result = result * 59 + ($entidadeEmpenho == null ? 43 : ((Object)$entidadeEmpenho).hashCode());
        Long $exercicioEmpenho = this.getExercicioEmpenho();
        result = result * 59 + ($exercicioEmpenho == null ? 43 : ((Object)$exercicioEmpenho).hashCode());
        Long $numeroLiquidacao = this.getNumeroLiquidacao();
        result = result * 59 + ($numeroLiquidacao == null ? 43 : ((Object)$numeroLiquidacao).hashCode());
        String $unidadeOrcamentaria = this.getUnidadeOrcamentaria();
        result = result * 59 + ($unidadeOrcamentaria == null ? 43 : $unidadeOrcamentaria.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        LocalDate $dataSaida = this.getDataSaida();
        result = result * 59 + ($dataSaida == null ? 43 : ((Object)$dataSaida).hashCode());
        String $destino = this.getDestino();
        result = result * 59 + ($destino == null ? 43 : $destino.hashCode());
        LocalDate $dataRetorno = this.getDataRetorno();
        result = result * 59 + ($dataRetorno == null ? 43 : ((Object)$dataRetorno).hashCode());
        BigDecimal $quantidadeDiarias = this.getQuantidadeDiarias();
        result = result * 59 + ($quantidadeDiarias == null ? 43 : ((Object)$quantidadeDiarias).hashCode());
        BigDecimal $valorDiarias = this.getValorDiarias();
        result = result * 59 + ($valorDiarias == null ? 43 : ((Object)$valorDiarias).hashCode());
        String $meioTransporte = this.getMeioTransporte();
        result = result * 59 + ($meioTransporte == null ? 43 : $meioTransporte.hashCode());
        BigDecimal $valorPassagem = this.getValorPassagem();
        result = result * 59 + ($valorPassagem == null ? 43 : ((Object)$valorPassagem).hashCode());
        String $motivo = this.getMotivo();
        result = result * 59 + ($motivo == null ? 43 : $motivo.hashCode());
        String $cargo = this.getCargo();
        result = result * 59 + ($cargo == null ? 43 : $cargo.hashCode());
        Long $numeroProcesso = this.getNumeroProcesso();
        result = result * 59 + ($numeroProcesso == null ? 43 : ((Object)$numeroProcesso).hashCode());
        Long $anoProcesso = this.getAnoProcesso();
        result = result * 59 + ($anoProcesso == null ? 43 : ((Object)$anoProcesso).hashCode());
        String $lotacao = this.getLotacao();
        result = result * 59 + ($lotacao == null ? 43 : $lotacao.hashCode());
        String $horaSaida = this.getHoraSaida();
        result = result * 59 + ($horaSaida == null ? 43 : $horaSaida.hashCode());
        String $horaRetorno = this.getHoraRetorno();
        result = result * 59 + ($horaRetorno == null ? 43 : $horaRetorno.hashCode());
        BigDecimal $valorEmpenho = this.getValorEmpenho();
        result = result * 59 + ($valorEmpenho == null ? 43 : ((Object)$valorEmpenho).hashCode());
        BigDecimal $valorAnulado = this.getValorAnulado();
        result = result * 59 + ($valorAnulado == null ? 43 : ((Object)$valorAnulado).hashCode());
        Long $quantidadeAnulacoes = this.getQuantidadeAnulacoes();
        result = result * 59 + ($quantidadeAnulacoes == null ? 43 : ((Object)$quantidadeAnulacoes).hashCode());
        String $secretaria = this.getSecretaria();
        result = result * 59 + ($secretaria == null ? 43 : $secretaria.hashCode());
        String $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : $matricula.hashCode());
        Long $noAto = this.getNoAto();
        result = result * 59 + ($noAto == null ? 43 : ((Object)$noAto).hashCode());
        LocalDate $dataAto = this.getDataAto();
        result = result * 59 + ($dataAto == null ? 43 : ((Object)$dataAto).hashCode());
        BigDecimal $gastosTotais = this.getGastosTotais();
        result = result * 59 + ($gastosTotais == null ? 43 : ((Object)$gastosTotais).hashCode());
        BigDecimal $valorUnitario = this.getValorUnitario();
        result = result * 59 + ($valorUnitario == null ? 43 : ((Object)$valorUnitario).hashCode());
        String $displayEmpenho = this.getDisplayEmpenho();
        result = result * 59 + ($displayEmpenho == null ? 43 : $displayEmpenho.hashCode());
        String $displayDataSaidaRetorno = this.getDisplayDataSaidaRetorno();
        result = result * 59 + ($displayDataSaidaRetorno == null ? 43 : $displayDataSaidaRetorno.hashCode());
        String $displayDataRetorno = this.getDisplayDataRetorno();
        result = result * 59 + ($displayDataRetorno == null ? 43 : $displayDataRetorno.hashCode());
        String $displayDataSaida = this.getDisplayDataSaida();
        result = result * 59 + ($displayDataSaida == null ? 43 : $displayDataSaida.hashCode());
        String $labelCargo = this.getLabelCargo();
        result = result * 59 + ($labelCargo == null ? 43 : $labelCargo.hashCode());
        Long $idTipoObjetivoDiaria = this.getIdTipoObjetivoDiaria();
        result = result * 59 + ($idTipoObjetivoDiaria == null ? 43 : ((Object)$idTipoObjetivoDiaria).hashCode());
        String $tipoObjetivoDiaria = this.getTipoObjetivoDiaria();
        result = result * 59 + ($tipoObjetivoDiaria == null ? 43 : $tipoObjetivoDiaria.hashCode());
        BigDecimal $valorHospedagem = this.getValorHospedagem();
        result = result * 59 + ($valorHospedagem == null ? 43 : ((Object)$valorHospedagem).hashCode());
        BigDecimal $valorEvento = this.getValorEvento();
        result = result * 59 + ($valorEvento == null ? 43 : ((Object)$valorEvento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DiariaPessoalDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", empenho=" + this.getEmpenho() + ", entidadeEmpenho=" + this.getEntidadeEmpenho() + ", exercicioEmpenho=" + this.getExercicioEmpenho() + ", numeroLiquidacao=" + this.getNumeroLiquidacao() + ", unidadeOrcamentaria=" + this.getUnidadeOrcamentaria() + ", nome=" + this.getNome() + ", dataSaida=" + this.getDataSaida() + ", destino=" + this.getDestino() + ", dataRetorno=" + this.getDataRetorno() + ", quantidadeDiarias=" + this.getQuantidadeDiarias() + ", valorDiarias=" + this.getValorDiarias() + ", meioTransporte=" + this.getMeioTransporte() + ", valorPassagem=" + this.getValorPassagem() + ", motivo=" + this.getMotivo() + ", cargo=" + this.getCargo() + ", numeroProcesso=" + this.getNumeroProcesso() + ", anoProcesso=" + this.getAnoProcesso() + ", lotacao=" + this.getLotacao() + ", horaSaida=" + this.getHoraSaida() + ", horaRetorno=" + this.getHoraRetorno() + ", valorEmpenho=" + this.getValorEmpenho() + ", valorAnulado=" + this.getValorAnulado() + ", quantidadeAnulacoes=" + this.getQuantidadeAnulacoes() + ", secretaria=" + this.getSecretaria() + ", matricula=" + this.getMatricula() + ", noAto=" + this.getNoAto() + ", dataAto=" + this.getDataAto() + ", gastosTotais=" + this.getGastosTotais() + ", valorUnitario=" + this.getValorUnitario() + ", displayEmpenho=" + this.getDisplayEmpenho() + ", displayDataSaidaRetorno=" + this.getDisplayDataSaidaRetorno() + ", displayDataRetorno=" + this.getDisplayDataRetorno() + ", displayDataSaida=" + this.getDisplayDataSaida() + ", labelCargo=" + this.getLabelCargo() + ", idTipoObjetivoDiaria=" + this.getIdTipoObjetivoDiaria() + ", tipoObjetivoDiaria=" + this.getTipoObjetivoDiaria() + ", valorHospedagem=" + this.getValorHospedagem() + ", valorEvento=" + this.getValorEvento() + ")";
    }

    @Generated
    public DiariaPessoalDTO(Long entidade, Long exercicio, Long empenho, Long entidadeEmpenho, Long exercicioEmpenho, Long numeroLiquidacao, String unidadeOrcamentaria, String nome, LocalDate dataSaida, String destino, LocalDate dataRetorno, BigDecimal quantidadeDiarias, BigDecimal valorDiarias, String meioTransporte, BigDecimal valorPassagem, String motivo, String cargo, Long numeroProcesso, Long anoProcesso, String lotacao, String horaSaida, String horaRetorno, BigDecimal valorEmpenho, BigDecimal valorAnulado, Long quantidadeAnulacoes, String secretaria, String matricula, Long noAto, LocalDate dataAto, BigDecimal gastosTotais, BigDecimal valorUnitario, String displayEmpenho, String displayDataSaidaRetorno, String displayDataRetorno, String displayDataSaida, String labelCargo, Long idTipoObjetivoDiaria, String tipoObjetivoDiaria, BigDecimal valorHospedagem, BigDecimal valorEvento) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.empenho = empenho;
        this.entidadeEmpenho = entidadeEmpenho;
        this.exercicioEmpenho = exercicioEmpenho;
        this.numeroLiquidacao = numeroLiquidacao;
        this.unidadeOrcamentaria = unidadeOrcamentaria;
        this.nome = nome;
        this.dataSaida = dataSaida;
        this.destino = destino;
        this.dataRetorno = dataRetorno;
        this.quantidadeDiarias = quantidadeDiarias;
        this.valorDiarias = valorDiarias;
        this.meioTransporte = meioTransporte;
        this.valorPassagem = valorPassagem;
        this.motivo = motivo;
        this.cargo = cargo;
        this.numeroProcesso = numeroProcesso;
        this.anoProcesso = anoProcesso;
        this.lotacao = lotacao;
        this.horaSaida = horaSaida;
        this.horaRetorno = horaRetorno;
        this.valorEmpenho = valorEmpenho;
        this.valorAnulado = valorAnulado;
        this.quantidadeAnulacoes = quantidadeAnulacoes;
        this.secretaria = secretaria;
        this.matricula = matricula;
        this.noAto = noAto;
        this.dataAto = dataAto;
        this.gastosTotais = gastosTotais;
        this.valorUnitario = valorUnitario;
        this.displayEmpenho = displayEmpenho;
        this.displayDataSaidaRetorno = displayDataSaidaRetorno;
        this.displayDataRetorno = displayDataRetorno;
        this.displayDataSaida = displayDataSaida;
        this.labelCargo = labelCargo;
        this.idTipoObjetivoDiaria = idTipoObjetivoDiaria;
        this.tipoObjetivoDiaria = tipoObjetivoDiaria;
        this.valorHospedagem = valorHospedagem;
        this.valorEvento = valorEvento;
    }

    @Generated
    public DiariaPessoalDTO() {
    }
}

