SELECT COUNT(*)
  FROM TRAMITACAO T
  LEFT OUTER JOIN PROCESSOS P 
    ON T.ENTIDADE = P.ENTIDADE 
   AND T.TIPO = P.TIPO
   AND T.NUMERO = P.NUMERO
   AND T.ANO = P.ANO
  LEFT OUTER JOIN ASSUNTO A 
    ON P.CODASSUNTO = A.CODIGO
  LEFT OUTER JOIN SITUACOES S 
    ON T.SITUACAO = S.CODIGO
  LEFT OUTER JOIN GRAUSIGILO G
    ON G.ID = P.GRAUSIGILO
  LEFT OUTER JOIN PARAMETROS B
    ON B.ENTIDADE = P.ENTIDADE
   AND B.EXERCICIO = P.ANO
   AND B.CODIGO = 91
   AND (B.VALOR IS NOT NULL AND B.VALOR <> '')
 WHERE P.ENTIDADE = :entidade
   AND P.TIPO = :tipo
   AND P.ANO = :exercicio
   AND T.SEQUENCIA = (SELECT MAX(X.SEQUENCIA) 
                        FROM TRAMITACAO X
                       WHERE X.TIPO = T.TIPO
                         AND X.ANO = T.ANO
                         AND X.NUMERO = T.NUMERO
                         AND X.ENTIDADE = T.ENTIDADE)
