SELECT RM.MES,
       CAST(COALESCE(SUM(PR.VALOR) + SUM(RM.VALORCORRECAOORCADO + RM.VALORCORRECAO),0) AS NUMERIC(15,2)) VALORPREVISTO,
      CAST(COALESCE(SUM(RM.VALORARRECADADO-RM.VALORESTARRECADADO-RM.VALORDEVOLUCAO+RM.VALORESTDEVOLUCAO),0) AS NUMERIC(15,2)) VALORARRECADADO    
FROM   RECEITAMENSAL RM

JOIN RECEITA R 
 ON  R.ENTIDADE = RM.ENTIDADE 
AND  R.EXERCICIO = RM.EXERCICIO 
AND  R.RECEITA = RM.RECEITA 
AND  R.FONTERECURSO = RM.FONTERECURSO 
AND  R.IDTIPOOPERACAORECEITA = RM.IDTIPOOPERACAORECEITA

LEFT JOIN PREVISAORECEITA PR
 ON R.ENTIDADE 						= PR.ENTIDADE
AND R.EXERCICIO 					= PR.EXERCICIO
AND R.FONTERECURSO 					= PR.FONTERECURSO
AND R.RECEITA 						= PR.RECEITA
AND R.IDTIPOOPERACAORECEITA 		= PR.IDTIPOOPERACAORECEITA
AND EXTRACT(MONTH FROM PR.DATA)     = RM.MES

WHERE  RM.ENTIDADE  = :entidade
AND    RM.EXERCICIO = :exercicio
AND    R.MOVSN='S'
GROUP BY RM.MES
ORDER BY RM.MES