SELECT D.ENTIDADE, D.EXERCICIO, SUBSTR(D.PROGRAMATICA,1, D.INICIO+D.TAMANHO-1) AS PROGRAMATICA, D.DESCRICAO, D.NIVEL, D.INICIO, D.TAMANHO, D.MOVSN AS ACEITAMOVIMENTACAO, 
       SUM(D.VALORPREVISTO) AS VALORPREVISTO,
       SUM(D.VALORPREVISTO + DESPESAMENSAL.VALORATUALIZADO) AS VALORATUALIZADO,
       SUM(DESPESAMENSAL.VALOREMPENHADO) AS VALOREMPENHADO,
       SUM(DESPESAMENSAL.VALORALIQUIDAR) AS VALOREMLIQUIDACAO,
       SUM(DESPESAMENSAL.VALORLIQUIDADO) AS VALORLIQUIDADO,
       SUM(DESPESAMENSAL.VALORPAGO) AS VALORPAGO
  FROM DESPESA D
  LEFT JOIN (SELECT ENTIDADE, EXERCICIO, PROGRAMATICA, FONTERECURSO,
                    SUM(DESPESAMENSAL.VALORSUPLEMENTACAO - DESPESAMENSAL.VALORESTSUPLEMENTACAO) AS VALORSUPLEMENTADO,
                    SUM(DESPESAMENSAL.VALORREDUCAO - DESPESAMENSAL.VALORESTREDUCAO) AS VALORREDUZIDO,
                    SUM(DESPESAMENSAL.VALORCORRECAOPREVISTO + DESPESAMENSAL.VALORSUPLEMENTACAO - DESPESAMENSAL.VALORESTSUPLEMENTACAO - DESPESAMENSAL.VALORREDUCAO + DESPESAMENSAL.VALORESTREDUCAO) AS VALORATUALIZADO,
                    SUM(DESPESAMENSAL.VALORCORRECAOPREVISTO) AS VALORCORRECAOPREVISTO, 
                    SUM(DESPESAMENSAL.VALOREMPENHO - DESPESAMENSAL.VALORANULACAOEMPENHO + DESPESAMENSAL.VALORESTANULACAOEMPENHO) AS VALOREMPENHADO, 
                    SUM(DESPESAMENSAL.VALORLIQUIDACAO - DESPESAMENSAL.VALORESTLIQUIDACAO) AS VALORLIQUIDADO,
                    SUM(DESPESAMENSAL.VALORPAGAMENTO - DESPESAMENSAL.VALORESTPAGAMENTO + DESPESAMENSAL.VALORRETENCAO) AS VALORPAGO,
                    SUM(DESPESAMENSAL.VALOREMPENHO - DESPESAMENSAL.VALORANULACAOEMPENHO + DESPESAMENSAL.VALORESTANULACAOEMPENHO -
                        DESPESAMENSAL.VALORLIQUIDACAO + DESPESAMENSAL.VALORESTLIQUIDACAO) AS VALORALIQUIDAR
               FROM DESPESAMENSAL
              WHERE ENTIDADE  = ?
                AND EXERCICIO = ?
                AND MES <= 12
              GROUP BY ENTIDADE, EXERCICIO, PROGRAMATICA, FONTERECURSO 
            ) DESPESAMENSAL
    ON D.ENTIDADE     = DESPESAMENSAL.ENTIDADE
   AND D.EXERCICIO    = DESPESAMENSAL.EXERCICIO
   AND D.PROGRAMATICA = DESPESAMENSAL.PROGRAMATICA 
   AND D.FONTERECURSO = DESPESAMENSAL.FONTERECURSO 
 WHERE D.ENTIDADE = ?
   AND D.EXERCICIO = ?
 GROUP BY D.ENTIDADE, D.EXERCICIO, SUBSTR(D.PROGRAMATICA,1, D.INICIO+D.TAMANHO-1), D.DESCRICAO, D.NIVEL, D.INICIO, D.TAMANHO, D.MOVSN
 ORDER BY SUBSTR(D.PROGRAMATICA,1, D.INICIO+D.TAMANHO-1)