SELECT A.ID,
       A.PESSOA,
       A.DATA,
       CASE A.TIPO
         WHEN 1 THEN 'INTERPOSIÇÃO'
         WHEN 2 THEN 'IMPUGNAÇÃO'
         WHEN 3 THEN 'SUSPENSÃO'
         WHEN 4 THEN 'ADIANTAMENTO'
         WHEN 5 THEN 'SOLICITAÇÃO DE INFORMAÇÕES'
         WHEN 6 THEN 'CONSULTAS E QUESTIONAMENTOS'
         WHEN 7 THEN 'DESPACHOS INTERNOS'
         WHEN 8 THEN 'OUTROS'
         ELSE 'NÃO INFORMADO'
       END AS TIPO,
       A.OBSERVACAO,
       A.NUMEROPROTOCOLO,
       A.DATAPROTOCOLO,
       CASE A.ANALISE
         WHEN 'D' THEN 'DEFERIDO'
         WHEN 'P' THEN 'DEFERIDO PARCIALMENTE'
         WHEN 'I' THEN 'INDEFERIDO'
       END AS ANALISE,
       A.ANALISEDESCRICAO,
       B.NOME,
       B.CNPJ_CPF
FROM CLLICITACAORECURSO A
  LEFT OUTER JOIN PESSOA B ON B.PESSOA = A.PESSOA
WHERE A.LICITACAO = :licitacao
AND A.TIPOLICITACAO = :tipoLicitacao 
AND A.EXERCICIOLICITACAO = :exercicio
AND A.ENTIDADE = :entidade
ORDER BY A.DATA DESC
