/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.web.rest.params;

import br.com.elotech.almoxarifado.dto.portal.ConsumoPorCentroCustoPortalParamsDTO;
import br.com.elotech.portaltransparencia.web.rest.params.ConsumoPorCentroCustoParams;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class ConsumoPorCentroCustoParams {
    public static final Long DEFAULT_NUMBER = -99L;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    private Long centroCustoOrigem;
    @NotNull
    private Long centroCustoDestino;
    @NotNull
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicio;
    @NotNull
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFinal;

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addExercicio(params);
        this.addEntidade(params);
        this.addCentroCustoOrigem(params);
        this.addCentroCustoDestino(params);
        this.addDataIni(params);
        this.addDataFim(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (!Objects.isNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (!Objects.isNull(this.entidade)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addDataIni(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataInicio)) {
            params.addValue("dataInicio", (Object)Date.valueOf(this.dataInicio), 91);
        }
    }

    private void addDataFim(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataFinal)) {
            params.addValue("dataFinal", (Object)Date.valueOf(this.dataFinal), 91);
        }
    }

    private void addCentroCustoOrigem(MapSqlParameterSource params) {
        this.centroCustoOrigem = Optional.ofNullable(this.centroCustoOrigem).orElse(DEFAULT_NUMBER);
        params.addValue("centroCustoOrigem", (Object)this.centroCustoOrigem, 2);
    }

    private void addCentroCustoDestino(MapSqlParameterSource params) {
        this.centroCustoDestino = Optional.ofNullable(this.centroCustoDestino).orElse(DEFAULT_NUMBER);
        params.addValue("centroCustoDestino", (Object)this.centroCustoDestino, 2);
    }

    public ConsumoPorCentroCustoPortalParamsDTO toOxyAdmEntity() {
        ConsumoPorCentroCustoPortalParamsDTO consumoPorCentroCustoPortalParamsDTO = new ConsumoPorCentroCustoPortalParamsDTO();
        consumoPorCentroCustoPortalParamsDTO.setEntidade(this.getEntidade());
        consumoPorCentroCustoPortalParamsDTO.setExercicio(this.getExercicio());
        consumoPorCentroCustoPortalParamsDTO.setCentroCustoOrigem(this.getCentroCustoOrigem());
        consumoPorCentroCustoPortalParamsDTO.setCentroCustoDestino(this.getCentroCustoDestino());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (this.getDataInicio() != null) {
            consumoPorCentroCustoPortalParamsDTO.setDataInicio(formatter.format(this.getDataInicio()));
        }
        if (this.getDataFinal() != null) {
            consumoPorCentroCustoPortalParamsDTO.setDataFinal(formatter.format(this.getDataFinal()));
        }
        return consumoPorCentroCustoPortalParamsDTO;
    }

    @Generated
    public static ConsumoPorCentroCustoParamsBuilder builder() {
        return new ConsumoPorCentroCustoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "ConsumoPorCentroCustoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", centroCustoOrigem=" + this.getCentroCustoOrigem() + ", centroCustoDestino=" + this.getCentroCustoDestino() + ", dataInicio=" + this.getDataInicio() + ", dataFinal=" + this.getDataFinal() + ")";
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getCentroCustoOrigem() {
        return this.centroCustoOrigem;
    }

    @Generated
    public Long getCentroCustoDestino() {
        return this.centroCustoDestino;
    }

    @Generated
    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setCentroCustoOrigem(Long centroCustoOrigem) {
        this.centroCustoOrigem = centroCustoOrigem;
    }

    @Generated
    public void setCentroCustoDestino(Long centroCustoDestino) {
        this.centroCustoDestino = centroCustoDestino;
    }

    @Generated
    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumoPorCentroCustoParams)) {
            return false;
        }
        ConsumoPorCentroCustoParams other = (ConsumoPorCentroCustoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$centroCustoOrigem = this.getCentroCustoOrigem();
        Long other$centroCustoOrigem = other.getCentroCustoOrigem();
        if (this$centroCustoOrigem == null ? other$centroCustoOrigem != null : !((Object)this$centroCustoOrigem).equals(other$centroCustoOrigem)) {
            return false;
        }
        Long this$centroCustoDestino = this.getCentroCustoDestino();
        Long other$centroCustoDestino = other.getCentroCustoDestino();
        if (this$centroCustoDestino == null ? other$centroCustoDestino != null : !((Object)this$centroCustoDestino).equals(other$centroCustoDestino)) {
            return false;
        }
        LocalDate this$dataInicio = this.getDataInicio();
        LocalDate other$dataInicio = other.getDataInicio();
        if (this$dataInicio == null ? other$dataInicio != null : !((Object)this$dataInicio).equals(other$dataInicio)) {
            return false;
        }
        LocalDate this$dataFinal = this.getDataFinal();
        LocalDate other$dataFinal = other.getDataFinal();
        return !(this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConsumoPorCentroCustoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $centroCustoOrigem = this.getCentroCustoOrigem();
        result = result * 59 + ($centroCustoOrigem == null ? 43 : ((Object)$centroCustoOrigem).hashCode());
        Long $centroCustoDestino = this.getCentroCustoDestino();
        result = result * 59 + ($centroCustoDestino == null ? 43 : ((Object)$centroCustoDestino).hashCode());
        LocalDate $dataInicio = this.getDataInicio();
        result = result * 59 + ($dataInicio == null ? 43 : ((Object)$dataInicio).hashCode());
        LocalDate $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        return result;
    }

    @Generated
    public ConsumoPorCentroCustoParams() {
    }

    @Generated
    public ConsumoPorCentroCustoParams(Long entidade, Long exercicio, Long centroCustoOrigem, Long centroCustoDestino, LocalDate dataInicio, LocalDate dataFinal) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.centroCustoOrigem = centroCustoOrigem;
        this.centroCustoDestino = centroCustoDestino;
        this.dataInicio = dataInicio;
        this.dataFinal = dataFinal;
    }
}

