/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.protocportal.dto.EstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.SerieItemDTO;
import br.com.elotech.portaltransparencia.protocportal.repository.EstatisticaRepository;
import br.com.elotech.portaltransparencia.protocportal.resource.params.EstatisticaParams;
import br.com.elotech.portaltransparencia.protocportal.service.EntidadeProtocoloService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class EstatisticaRepositoryImpl
implements EstatisticaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstatisticaRepositoryImpl.class);
    private static final String FILTRO_CONSTANT = "$[FILTRO]";
    private static final String MEDIA_RESPOSTAS_ORACLE = "db/sql/protoc/media-respostas-estatistica-oracle.sql";
    private static final String MEDIA_RESPOSTAS_POSTGRES = "db/sql/protoc/media-respostas-estatistica-postgres.sql";
    private static final String ESTATISTICAS = "db/sql/protoc/estatisticas.sql";
    private static final String PROCESSOS_POR_SEXO = "db/sql/protoc/ProcessosPorSexo.sql";
    private static final String PROCESSOS_POR_IDADE = "db/sql/protoc/ProcessosPorIdade.sql";
    private static final String PROCESSOS_POR_ESCOLARIDADE = "db/sql/protoc/ProcessosPorEscolaridade.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeProtocoloService entidadeProtocoloService;

    @Autowired
    public EstatisticaRepositoryImpl(@Qualifier(value="wrapperProtocolo") DatasourceWrapper datasourceWrapper, EntidadeProtocoloService entidadeProtocoloService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeProtocoloService = entidadeProtocoloService;
    }

    public BigDecimal getMediaResposta(EstatisticaParams params) {
        StringBuilder query = new StringBuilder(this.getSQL());
        params.getExercicio().ifPresent(item -> query.append(" AND A.ANO = :exercicio "));
        this.entidadeProtocoloService.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> query.append(" AND A.ENTIDADE = ").append(item));
        this.consoleLogger(query);
        BigDecimal result = (BigDecimal)this.datasourceWrapper.getJdbcTemplate().queryForObject(query.toString(), (SqlParameterSource)params.toJdbcParameter(), BigDecimal.class);
        return result.setScale(2, 4);
    }

    private void consoleLogger(StringBuilder query) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
        }
    }

    public List<EstatisticaDTO> findEstatisticas(EstatisticaParams params) {
        String sql = FileUtils.readResourceAsString((String)ESTATISTICAS);
        StringBuilder filtro = new StringBuilder();
        params.getExercicio().ifPresent(item -> filtro.append(" AND E.EXERCICIO = :exercicio "));
        this.entidadeProtocoloService.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> filtro.append(" AND E.ENTIDADE = ").append(item));
        StringBuilder query = new StringBuilder(sql.replace(FILTRO_CONSTANT, filtro.toString()));
        this.consoleLogger(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EstatisticaDTO.class));
    }

    private String getSQL() {
        if (SqlUtils.isPostgres((String)this.datasourceWrapper.getPlatform())) {
            return FileUtils.readResourceAsString((String)MEDIA_RESPOSTAS_POSTGRES);
        }
        return FileUtils.readResourceAsString((String)MEDIA_RESPOSTAS_ORACLE);
    }

    public List<SerieItemDTO> findProcessosPorGenero(EstatisticaParams params) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_SEXO);
        StringBuilder filtro = new StringBuilder();
        this.entidadeProtocoloService.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> filtro.append(" AND ENTIDADE = ").append(item));
        sql = sql.replace(FILTRO_CONSTANT, filtro.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(SerieItemDTO.class));
    }

    public List<SerieItemDTO> findProcessosPorIdade(EstatisticaParams params) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_IDADE);
        StringBuilder filtro = new StringBuilder();
        this.entidadeProtocoloService.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> filtro.append(" AND P.ENTIDADE = ").append(item));
        sql = sql.replace(FILTRO_CONSTANT, filtro.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(SerieItemDTO.class));
    }

    public List<SerieItemDTO> findProcessosPorEscolaridade(EstatisticaParams params) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_ESCOLARIDADE);
        StringBuilder filtro = new StringBuilder();
        this.entidadeProtocoloService.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> filtro.append(" AND P.ENTIDADE = ").append(item));
        sql = sql.replace(FILTRO_CONSTANT, filtro.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(SerieItemDTO.class));
    }
}

