/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RealizacaoReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ReceitaRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.EntidadeContabilidadeRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ReceitaSustentacaoRepositoryImpl
implements ReceitaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceitaSustentacaoRepositoryImpl.class);
    private static final String FILTRO = "$[FILTRO]";
    private static final String FILTROFONTERECURSO = "$[FILTROFONTERECURSO]";
    private static final String RECEITAS = "db/sql/contab/receitas.sql";
    private static final String RECEITAS_DETALHADAS = "db/sql/contab/receitas-detalhadas.sql";
    private static final String RECEITAS_POR_FONTE_RECURSO = "db/sql/contab/receitasPorFonteRecurso.sql";
    private static final String DETALHE_RECEITAS_POR_FONTE_RECURSO = "db/sql/contab/detalheReceitasPorFonteRecurso.sql";
    private static final String RECEITA = "db/sql/contab/receita.sql";
    private static final String RECEITAS_DIA = "db/sql/contab/receitas-dia.sql";
    private static final String RECEITAS_RAZAO = "db/sql/contab/receitas-razao.sql";
    private static final String RECEITAS_GRAFICO_ANUAL = "db/sql/contab/receitas-grafico-anual.sql";
    private static final String RECEITAS_COVID = "db/sql/contab/receitasCovid.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeRepositoryImpl entidadeContabilidade;
    private final PortalParametroService portalParametroService;
    private final EntidadeContabilidadeService entidadeService;

    @Autowired
    public ReceitaSustentacaoRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper, EntidadeContabilidadeRepositoryImpl entidadeContabilidade, PortalParametroService portalParametroService, EntidadeContabilidadeService entidadeService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeContabilidade = entidadeContabilidade;
        this.portalParametroService = portalParametroService;
        this.entidadeService = entidadeService;
    }

    public List<ReceitaDTO> findReceitas(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITAS));
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    public List<ReceitaDTO> findReceitasDetalhada(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)RECEITAS_DETALHADAS);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    public List<ReceitaDTO> findReceitasPorFonteRecurso(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)RECEITAS_POR_FONTE_RECURSO);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    public List<ReceitaDTO> findDetalheReceitasPorFonteRecurso(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)DETALHE_RECEITAS_POR_FONTE_RECURSO);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    private void consoleLogger(FindReceitaParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public List<ReceitaDTO> findReceitaValoresDia(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITAS_DIA));
        sql = this.concatenarFiltroReceitaDia(params, sql);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    public List<RealizacaoReceitaDTO> findReceitaValoresRazao(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITAS_RAZAO));
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(RealizacaoReceitaDTO.class));
    }

    private Long quantidadeTotal(FindReceitaParams params, String sql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId(), params.getExercicio()).intValue()), Long.class);
    }

    public Page<ReceitaDTO> findReceitasCovid(FindReceitaParams params, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)RECEITAS_COVID);
        Object filter = "";
        if (params.getCovid().isPresent()) {
            filter = " AND COALESCE(RECEITA.COVID19,'N') = 'S' ";
        }
        if (!SimNao.toBoolean((String)this.portalParametroService.getPortalParametroValor(params.getEntidade(), params.getExercicio(), Parametros.PARAM_RECEITAS_ENTIDADES_DIFERENTES)).booleanValue()) {
            filter = params.getEntidade() > 0L ? (String)filter + "AND RECEITA.ENTIDADE  = " + params.getEntidade() : (String)filter + "AND RECEITA.ENTIDADE " + this.entidadeService.resolveWhereSQL(params.getEntidade());
        }
        if (params.getReceitaLike().isPresent()) {
            filter = (String)filter + " AND UPPER(RECEITA.RECEITA) like UPPER(:receitaLike)";
        }
        if (params.getDescricaoReceita().isPresent()) {
            filter = (String)filter + " AND UPPER(RECEITA.DESCRICAO) like UPPER(:descricaoReceita)";
        }
        if (params.getFonteRecurso().isPresent()) {
            filter = (String)filter + " AND FONTERECURSO.FONTERECURSO = :fonteRecurso";
        }
        if (params.getDescricaoFonteRecurso().isPresent()) {
            filter = (String)filter + " AND UPPER(FONTERECURSO.DESCRICAO) like UPPER(:descricaoFonteRecurso)";
        }
        sql = sql.replace(FILTRO, (CharSequence)filter);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)" ORDER BY TB2.RECEITA ");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        this.consoleLogger(params, query);
        List receita = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
        return new PageImpl(receita, pageable, this.quantidadeTotal(params, sql).longValue());
    }

    public Optional<ReceitaDTO> findReceita(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITA));
        this.consoleLogger(params, sql);
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(ReceitaDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)rowMapper).stream().findFirst();
    }

    private String concatenarFiltros(FindReceitaParams params, String sqlOriginal) {
        StringBuilder filtro = new StringBuilder();
        params.getDataInicial().ifPresent(i -> filtro.append(" AND RD.DATA >= :dataInicial "));
        params.getDataFinal().ifPresent(i -> filtro.append(" AND RD.DATA <= :dataFinal "));
        params.getFonteRecurso().ifPresent(i -> filtro.append(" AND R.FONTERECURSO = :fonteRecurso "));
        return sqlOriginal.replace(FILTRO, filtro.toString());
    }

    private String concatenarFiltroReceitaDia(FindReceitaParams params, String sqlOriginal) {
        StringBuilder filtro = new StringBuilder();
        params.getFonteRecursoRateio().ifPresent(i -> filtro.append(" AND FONTERECURSO.FONTERECURSO = :fonteRecursoRateio "));
        return sqlOriginal.replace(FILTROFONTERECURSO, filtro.toString());
    }

    public List<ReceitaDTO> findReceitaValorMes(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITAS_GRAFICO_ANUAL));
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }
}

