/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosNaturezaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisVinculadasDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.LeisAtosRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import br.com.elotech.portaltransparencia.contabportal.service.IntegradoComUnicoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LeisAtosRepositoryImpl
implements LeisAtosRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeisAtosRepositoryImpl.class);
    private static final String LEISATOS = "db/sql/contab/leisatos.sql";
    private static final String LEISATOS_ARQUIVOS = "db/sql/contab/leisatos_arquivo.sql";
    private static final String LEISVINCULADAS = "db/sql/contab/leisVinculadas.sql";
    private static final String LEISATOS_UNICO = "db/sql/contab/leisatos_unico.sql";
    private static final String EXISTSUNICOLEIATO = "db/sql/contab/existsleiatounico.sql";
    public static final String SCHEMA_AISE = "schema_aise";
    public static final String SCHEMA_SISCOP = "schema_siscop";
    private final DatasourceWrapper datasourceWrapper;
    @Autowired
    private final DBConfigProperties dbConfigProperties;

    @Autowired
    public LeisAtosRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper, DBConfigProperties dbConfigProperties) {
        this.datasourceWrapper = datasourceWrapper;
        this.dbConfigProperties = dbConfigProperties;
    }

    public boolean existsDataLeiAtosUnico(LeisAtosParams params) {
        StringBuilder query = new StringBuilder(String.format(FileUtils.readResourceAsString((String)EXISTSUNICOLEIATO), this.dbConfigProperties.getUnico().getSchema()));
        query.append("\n WHERE A.ENTIDADE = :entidade");
        query.append("\n   AND A.ANO = :exercicio ");
        List list = new ArrayList();
        list = this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
        return !list.isEmpty();
    }

    public List<LeisAtosDTO> findLeisAtos(LeisAtosParams params) {
        IntegradoComUnicoService integradoComUnicoService = new IntegradoComUnicoService(this.dbConfigProperties);
        StringBuilder query = new StringBuilder();
        if (!integradoComUnicoService.isIntegradoComUnico()) {
            query.append(FileUtils.readResourceAsString((String)LEISATOS));
        } else if (this.existsDataLeiAtosUnico(params)) {
            query.append(String.format(FileUtils.readResourceAsString((String)LEISATOS_UNICO), this.dbConfigProperties.getUnico().getSchema(), this.dbConfigProperties.getUnico().getSchema()));
        } else {
            query.append(FileUtils.readResourceAsString((String)LEISATOS));
        }
        query.append("\n AND A.ENTIDADE = :entidade");
        if (params.getSubAbaLeiAtos().isPresent() && !"geral".equals(params.getSubAbaLeiAtos().get())) {
            query.append(String.format(" AND A.MOSTRAR%s = 'S'", ((String)params.getSubAbaLeiAtos().get()).toUpperCase(Locale.getDefault())));
        }
        params.getAno().ifPresent(item -> query.append("\n   AND A.EXERCICIO = :ano "));
        params.getNatureza().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(C.DESCRICAO)) LIKE tiraacento(UPPER(:natureza)) "));
        params.getNumero().ifPresent(item -> query.append("   AND A.NUMERO = :numero "));
        params.getDescricaoSumula().ifPresent(item -> query.append("\n AND ((tiraacento(UPPER(B.DESCRICAO)) LIKE tiraacento(UPPER(:descricaoSumula))) OR (tiraacento(UPPER(A.SUMULA)) LIKE tiraacento(UPPER(:descricaoSumula))))"));
        if (!params.getAno().isPresent()) {
            params.getDataInicial().ifPresent(item -> query.append("\n   AND A.DATA >= :dataInicial "));
            params.getDataFinal().ifPresent(item -> query.append("\n   AND A.DATA <= :dataFinal "));
        }
        params.getTipoDocumentoLegal().ifPresent(item -> query.append("\n   AND TDL.CODIGO = :tipoDocumentoLegal "));
        params.getTipoEscopo().ifPresent(item -> query.append("\n AND B.CODIGO = :tipoEscopo "));
        this.loggerSql(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
    }

    private void loggerSql(StringBuilder query) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
        }
    }

    public List<LeisAtosDTO> findOneLeiAto(LeisAtosParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LEISATOS));
        params.getId().ifPresent(id -> query.append("   AND A.ID = :id "));
        this.loggerSql(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
    }

    public List<LeisVinculadasDTO> findLeisVinculadas(Long entidade, Long exercicio, Long idLeiVinculadora) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LEISVINCULADAS));
        MapSqlParameterSource params = new MapSqlParameterSource();
        query.append(" WHERE V.ENTIDADE = :entidade ");
        query.append("   AND V.IDLEIVINCULADORA = :id ");
        params.addValue("entidade", (Object)entidade, 2);
        params.addValue("exercicio", (Object)exercicio, 2);
        params.addValue("id", (Object)idLeiVinculadora, 2);
        this.loggerSql(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LeisVinculadasDTO.class));
    }

    public List<LeisAtosNaturezaDTO> findLeisAtosNatureza(LeisAtosParams params) {
        StringBuilder query = new StringBuilder();
        IntegradoComUnicoService integradoComUnicoService = new IntegradoComUnicoService(this.dbConfigProperties);
        Object tabela = "NATUREZALEI";
        if (integradoComUnicoService.isIntegradoComUnico() && this.existsDataLeiAtosUnico(params)) {
            tabela = this.dbConfigProperties.getUnico().getSchema() + ".TIPOLEINATUREZA";
        }
        query.append(String.format(" SELECT N.ID, N.CODIGO, N.DESCRICAO FROM %s N ", tabela));
        query.append(" ORDER BY N.CODIGO ");
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosNaturezaDTO.class));
    }

    public List<LeisAtosNaturezaDTO> findTiposDocumentoLegal() {
        StringBuilder query = new StringBuilder();
        query.append(" SELECT a.codigo, a.descricao FROM tipodocumentolegal a ");
        query.append("\n ORDER BY a.descricao");
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosNaturezaDTO.class));
    }

    public List<LeisAtosNaturezaDTO> findTiposEscopo() {
        StringBuilder query = new StringBuilder();
        query.append(" SELECT T.* FROM TIPOESCOPO T ");
        query.append(" WHERE T.VERSAO = (SELECT MAX(VERSAO) FROM TIPOESCOPO) ");
        query.append(" ORDER BY T.DESCRICAO ");
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosNaturezaDTO.class));
    }

    public List<LeisAtosArquivoDTO> findLeisArquivos(Long entidade, Long exercicio, Long id) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LEISATOS_ARQUIVOS).replace("schema_eloarquivo", "ELOARQUIVO"));
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("IDLEIATO", (Object)id, 2);
        this.loggerSql(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosArquivoDTO.class));
    }
}

