/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.service;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoContent;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoInterface;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

@Service
public class ArquivoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArquivoService.class);
    public static final String SCHEMA_ELOARQUIVO = "schema_eloarquivo";
    private static final Long MAX_SIZE_POOL = 0xA00000L;
    private final EloArquivoRepository arquivoRepository;
    private final DBConfigProperties dbConfigProperties;
    private final DatasourceWrapper datasourceWrapper;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final RestTemplateBuilder restTemplateBuilder;

    @Autowired
    public ArquivoService(EloArquivoRepository arquivoRepository, DBConfigProperties dbConfigProperties, @Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper, ArquivoStorageFeignClient arquivoStorageFeignClient, RestTemplateBuilder restTemplateBuilder) {
        this.arquivoRepository = arquivoRepository;
        this.dbConfigProperties = dbConfigProperties;
        this.datasourceWrapper = datasourceWrapper;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.restTemplateBuilder = restTemplateBuilder;
    }

    public ArquivoInterface getArquivoInterface(Long id) {
        return this.arquivoRepository.findByIdProjection(id);
    }

    public Arquivo findOne(Long id) {
        return (Arquivo)this.arquivoRepository.findOne((Object)id);
    }

    public Long getTamanhoArquivo(Long id) {
        return this.arquivoRepository.getTamanhoArquivo(id);
    }

    public String getNomeSchemaEloArquivo() {
        if (Objects.nonNull(this.dbConfigProperties.getEloarquivo()) && StringUtils.isNotBlank((String)this.dbConfigProperties.getEloarquivo().getSchema())) {
            return this.dbConfigProperties.getEloarquivo().getSchema();
        }
        return "ELOARQUIVO";
    }

    public Arquivo save(Arquivo arquivo) {
        return (Arquivo)this.arquivoRepository.save((Object)arquivo);
    }

    public void remove(Long id) {
        this.arquivoRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public Arquivo findArquivoPortal(Long id) {
        try {
            ArquivoDTO arquivoDto = this.arquivoStorageFeignClient.findOne(id);
            Boolean isArquivoConvertidoS3 = Objects.nonNull(arquivoDto) && Objects.nonNull(arquivoDto.getFullPath()) && Objects.nonNull(arquivoDto.getModulo());
            if (isArquivoConvertidoS3.booleanValue()) {
                ArquivoContent arquivoContent = new ArquivoContent();
                arquivoContent.setId(id);
                arquivoContent.setBinary(this.baixarArquivoS3(arquivoDto));
                Arquivo arquivoEntity = new Arquivo();
                arquivoEntity.setId(id);
                arquivoEntity.setContent(arquivoContent);
                arquivoEntity.setNome(arquivoDto.getNome());
                arquivoEntity.setDataCriacao(LocalDate.now());
                return arquivoEntity;
            }
        }
        catch (Exception ex) {
            log.warn("N\u00e3o foi poss\u00edvel consultar o arquivo no \u00fanico. Fazendo fallback para eloarquivo. [{}]", (Object)ex.getMessage(), (Object)ex);
        }
        if (SqlUtils.isPostgres((String)this.datasourceWrapper.getPlatform())) {
            return this.findArquivoByPart(id);
        }
        return this.findOne(id);
    }

    private byte[] baixarArquivoS3(ArquivoDTO arquivo) {
        ArquivoUrl arquivoUrl = this.arquivoStorageFeignClient.getUrlDownload(arquivo.getFullPath(), arquivo.getNome());
        byte[] contentByte = new byte[]{};
        log.info("Iniciando busca do conte\u00fado do arquivo.");
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplateBuilder.build().exchange(new URI(arquivoUrl.getUrlAssinada()), HttpMethod.GET, entity, byte[].class);
            contentByte = (byte[])response.getBody();
        }
        catch (URISyntaxException | RestClientException e) {
            log.error("Erro na busca do conte\u00fado do arquivo. Erro: {}", (Object)e.getMessage());
        }
        return contentByte;
    }

    public Arquivo findArquivoByPart(Long id) {
        Long tamanhoTotal = this.arquivoRepository.getTamanhoBytes(id);
        if (tamanhoTotal != null && tamanhoTotal > MAX_SIZE_POOL) {
            String nome = this.arquivoRepository.getNameArquivo(id);
            Long posIni = 1L;
            Long posFim = MAX_SIZE_POOL;
            ByteBuffer allBytes = ByteBuffer.allocate(tamanhoTotal.intValue());
            while (posIni <= tamanhoTotal) {
                byte[] partBytes = posFim > tamanhoTotal ? this.arquivoRepository.getPartBytes(id, Integer.valueOf(posIni.intValue()), Integer.valueOf(tamanhoTotal.intValue() - posIni.intValue())) : this.arquivoRepository.getPartBytes(id, Integer.valueOf(posIni.intValue()), Integer.valueOf(MAX_SIZE_POOL.intValue()));
                allBytes.put(partBytes);
                posIni = posIni + MAX_SIZE_POOL;
                posFim = posIni + MAX_SIZE_POOL;
            }
            ArquivoContent content = new ArquivoContent();
            content.setBinary(allBytes.array());
            Arquivo arquivo = new Arquivo();
            arquivo.setId(id);
            arquivo.setNome(nome);
            arquivo.setContent(content);
            return arquivo;
        }
        return (Arquivo)this.arquivoRepository.findOne((Object)id);
    }
}

