SELECT G.ID, 
       G.DESCRICAO, 
       G.MOSTRAWEB, 
       G.FILTRARPOREXERCICIO,
       SG.ID AS IDSUBGRUPO,
       SGE.ID AS IDSUBGRUPOEXERCICIO,
       SG.DESCRICAO AS DESCRICAOSUBGRUPO,
       PUB.ID AS IDPUBLICACAO,
       PUB.DESCRICAO AS DESCRICAOPUBLICACAO,
       PUB.NOMEARQUIVO,
       PUB.PERIODO,
       PUB.TIPOPERIODO,
       PUB.RESUMO,
       ARQ.IDARQUIVO,
       PUB.LINKARQUIVO AS LINK,
       LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO,
       ARQ.DATAARQUIVO,
	   COALESCE(PUB.ORDEM,0)
 FROM ELOPORTALGRUPOPUBLICACAO G
 LEFT OUTER JOIN ELOPORTALSUBGRUPOPUBLICACAO SG ON
     G.ID = SG.IDGRUPOPUBLICACAO
 LEFT OUTER JOIN ELOPORTALSUBGRUPOEXERCICIO SGE ON
     SG.ID = SGE.IDSUBGRUPOPUBLICACAO
     AND SGE.ENTIDADE = :entidade
     AND ((G.FILTRARPOREXERCICIO = 'S' AND SGE.EXERCICIO = :exercicio) OR (G.FILTRARPOREXERCICIO = 'N'))
     AND SGE.MOSTRAWEB = 'S'
 LEFT OUTER JOIN ELOPORTALPUBLICACAO PUB ON
     PUB.IDSUBGRUPOEXERCICIO = SGE.ID
     AND PUB.ENTIDADE = :entidade
     AND ((G.FILTRARPOREXERCICIO = 'S' AND PUB.EXERCICIO = :exercicio) OR (G.FILTRARPOREXERCICIO = 'N'))
 LEFT OUTER JOIN ARQUIVO ARQ 
 	ON ARQ.ID = PUB.IDARQUIVO
 LEFT OUTER JOIN schema_eloarquivo.ARQUIVO_CONTENT AC
    ON ARQ.ID =  AC.ID
 LEFT OUTER JOIN ELOPORTALGRUPOPUBLENTIDADE GPE 
    ON GPE.ENTIDADE = :entidade
    AND GPE.IDGRUPO = G.ID
 WHERE GPE.MOSTRAWEB = 'S' 
 $[filtroTipoPublicacao]
 ORDER BY G.DESCRICAO, SG.ORDEM, IDSUBGRUPO, CASE WHEN COALESCE(PUB.ORDEM,0) = 0 THEN 8 ELSE 17 END, PUB.ID, PUB.PERIODO, PUB.DESCRICAO
