/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.portaltransparencia.contabportal.domain.dto.GastoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.DashboardRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.DashboardService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DashboardServiceImpl
implements DashboardService {
    private final DashboardRepository repository;

    @Autowired
    public DashboardServiceImpl(DashboardRepository repository) {
        this.repository = repository;
    }

    @Cacheable(value={"dashboard-receitas-empenhados"})
    public List<ReceitaDTO> findReceitasEmpenhadosPorMes(FindReceitaParams params) {
        return this.repository.findReceitasEmpenhadosPorMes(params);
    }

    @Cacheable(value={"dashboard-valor-receita"})
    public BigDecimal getReceitaValorAtualizado(FindReceitaParams params) {
        return this.repository.getReceitaValorAtualizado(params);
    }

    @Cacheable(value={"dashboard-valor-despesa"})
    public BigDecimal getDespesaValorAtualizado(FindReceitaParams params) {
        return this.repository.getDespesaValorAtualizado(params);
    }

    public List<GastoDTO> findGastosPessoal(FindReceitaParams params) {
        return this.repository.findGastosPessoal(params);
    }

    public List<GastoDTO> findGastosEducacao(FindReceitaParams params) {
        return this.repository.findGastosEducacao(params);
    }

    public List<GastoDTO> findGastosSaude(FindReceitaParams params) {
        return this.repository.findGastosSaude(params);
    }
}

