 SELECT A.ENTIDADE,           A.EXERCICIO,
        A.EXERCICIOLICITACAO, A.TIPOLICITACAO,
        A.LICITACAO,          A.PESSOA,
        P.NOME,               P.CNPJ_CPF AS CNPJCPF, 
        A.DATA,               ARQ.IDARQUIVO, 
        case when ARQ.NOMEARQUIVO is null then ELOARQ.NOME 
             else ARQ.NOMEARQUIVO 
        end as NOMEARQUIVO, 
        ARQ.DATA AS DATAARQUIVO,
        LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO
   FROM CLADJUDICACAO A
   LEFT JOIN CLLICITACAO B 
     ON A.ENTIDADE = B.ENTIDADE
    AND A.EXERCICIOLICITACAO = B.EXERCICIO
    AND A.TIPOLICITACAO = B.TIPOLICITACAO
    AND A.LICITACAO = B.LICITACAO
   LEFT JOIN PESSOA P
     ON A.PESSOA = P.PESSOA   
   LEFT JOIN ARQUIVO ARQ 
     ON A.IDARQUIVO = ARQ.ID 
   LEFT JOIN schema_eloarquivo.ARQUIVO ELOARQ 
     ON ELOARQ.ID = ARQ.IDARQUIVO 
   LEFT JOIN schema_eloarquivo.ARQUIVO_CONTENT AC 
     ON AC.ID = ARQ.IDARQUIVO 
  WHERE A.ENTIDADE           = :entidade
    AND A.EXERCICIO          = :exercicio
    AND A.EXERCICIOLICITACAO = :exercicioLicitacao
    AND A.TIPOLICITACAO      = :tipoLicitacao
    AND A.LICITACAO          = :licitacao
    AND A.PESSOA             = :pessoa  
    AND EXISTS (
    SELECT ANALIS.ENTIDADE FROM CLANALISEVENCEDOR ANALIS 
     WHERE A.ENTIDADE = ANALIS.ENTIDADE
       AND A.EXERCICIOLICITACAO = ANALIS.EXERCICIOLICITACAO
       AND A.TIPOLICITACAO = ANALIS.TIPOLICITACAO
       AND A.LICITACAO = ANALIS.LICITACAO
       AND A.PESSOA = ANALIS.PESSOA
       AND ANALIS.VENCEDOR = 'S')