/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioEmpenhoDTO;
import br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class PatrimonioMovimentoEmpenhoRepository {
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public PatrimonioMovimentoEmpenhoRepository(@Qualifier(value="dataSource") DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public List<PatrimonioEmpenhoDTO> getPatrimonioEmpenho(EmpenhoParams params) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT DISTINCT EXERCICIO, EMPENHO FROM ( ");
        sql.append("    SELECT ME.EMPENHOANO AS EXERCICIO, ME.EMPENHO  ");
        sql.append("      FROM PAT_MOVIMENTOITEM MI ");
        sql.append("      LEFT OUTER JOIN PAT_MOVIMENTOEMPENHO ME ");
        sql.append("        ON MI.ENTIDADE = ME.ENTIDADE ");
        sql.append("       AND MI.EXERCICIO = ME.EXERCICIO ");
        sql.append("       AND MI.CODIGO = ME.CODIGO ");
        sql.append("     WHERE ME.ENTIDADE = ").append(params.getEntidade());
        sql.append("       AND MI.TIPO = '").append(params.getTipoBem()).append("' ");
        sql.append("       AND MI.CHAPA = '").append(params.getChapaBem()).append("' ");
        sql.append("     UNION ALL ");
        sql.append("    SELECT A.EMPENHOANO EXERCICIO, A.EMPENHO ");
        sql.append("      FROM PAT_BEMXEMPENHO A ");
        sql.append("     WHERE A.ENTIDADE = ").append(params.getEntidade());
        sql.append("       AND A.TIPO = '").append(params.getTipoBem()).append("' ");
        sql.append("       AND A.CHAPA = '").append(params.getChapaBem()).append("' ");
        sql.append("     ) EMPENHO ");
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(PatrimonioEmpenhoDTO.class));
    }
}

