SELECT	OPR.ENTIDADE,
		OPR.ANODOCORIGEM AS EXERCICIO,
		OPR.NODOCORIGEM AS EMPENHO,
		OPR.UNIDADEDOCORIGEM AS UNIDADEORCAMENTARIA,
		OPR.EXERCICIO AS EXERCICIOLIQUIDACAO,
		OPR.NOLIQUIDACAO,
		OP.DATA AS DATA,
		SUM(OPR.VALOR) AS VALOR,
		SUM(CASE WHEN OP.CANCELADO = 'S' THEN OPR.VALOR ELSE 0 END) AS VALORESTORNADO,
		CASE
			WHEN COALESCE(TX.CODIGO, 0) = 17 THEN '[F] - PENSÃO ALIMENTÍCIA'
			ELSE COALESCE(CC.DESCRICAO, P.DESCRICAO)
		END AS DESCRICAO
FROM	ORDEMPAGAMENTO_RETENCAO OPR
LEFT OUTER JOIN ORDEMPAGAMENTO OP ON
	OPR.ENTIDADE = OP.ENTIDADE
	AND OPR.EXERCICIO = OP.EXERCICIO
	AND OPR.NOORDEM = OP.NOORDEM
LEFT OUTER JOIN EMPENHO E ON
	OPR.ENTIDADE = E.ENTIDADE
	AND OPR.ANODOCORIGEM = E.EXERCICIO
	AND OPR.NODOCORIGEM = E.EMPENHO
	AND OPR.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
LEFT OUTER JOIN CONTACORRENTE CC ON
	OPR.ENTIDADE = CC.ENTIDADE
	AND OPR.IDCONTACORRENTE = CC.IDCONTACORRENTE
LEFT OUTER JOIN PLANO P ON
	OPR.ENTIDADE = P.ENTIDADE
	AND OPR.EXERCICIO = P.EXERCICIO
	AND OPR.CODIGORETENCAO = P.CONTA
LEFT JOIN CADASTROEXTRA CX ON
	CX.ID = CC.IDCADASTROEXTRA
	AND CX.ENTIDADE = CC.ENTIDADE
LEFT JOIN TIPOEXTRAORCAMENTARIO TX ON
	TX.ID = CX.IDTIPOEXTRAORCAMENTARIO