/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.saude.resource;

import br.com.elotech.portaltransparencia.saude.domain.dto.FilaEsperaDTO;
import br.com.elotech.portaltransparencia.saude.domain.dto.PacienteFilaEsperaDTO;
import br.com.elotech.portaltransparencia.saude.service.FilaEsperaService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/filas-atendimento-saude"})
public class FilaEsperaResource {
    private final FilaEsperaService filaEsperaService;

    public FilaEsperaResource(FilaEsperaService filaEsperaService) {
        this.filaEsperaService = filaEsperaService;
    }

    @GetMapping
    public ResponseEntity<List<FilaEsperaDTO>> findFilasEspera() {
        return ResponseEntity.ok((Object)this.filaEsperaService.findFilasEpera());
    }

    @GetMapping(value={"/cns/{cns}"})
    public ResponseEntity<List<FilaEsperaDTO>> findFilasEsperaFiltros(@PathVariable String cns) {
        return ResponseEntity.ok((Object)this.filaEsperaService.findFilasEperaCns(cns));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<List<PacienteFilaEsperaDTO>> findPacientesDaFila(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.filaEsperaService.findPacientesDaFila(id));
    }

    @GetMapping(value={"/{id}/cns/{cns}"})
    public ResponseEntity<List<PacienteFilaEsperaDTO>> findPacienteDaFilaComCns(@PathVariable Long id, @PathVariable String cns) {
        return ResponseEntity.ok((Object)this.filaEsperaService.findPacienteDaFilaComCns(id, cns));
    }
}

