/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.aiseportal.repository.UltimaAtualizacaoAiseRepository;
import br.com.elotech.portaltransparencia.aiseportal.repository.UltimaAtualizacaoServidoresRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.UltimaAtualizacaoRepository;
import br.com.elotech.portaltransparencia.contabportal.service.UltimaAtualizacaoService;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UltimaAtualizacaoService {
    private final UltimaAtualizacaoRepository ultimaAtualizacaoRepository;
    private final UltimaAtualizacaoAiseRepository ultimaAtualizacaoAiseRepository;
    private final UltimaAtualizacaoServidoresRepository servidoresRepository;
    private final PortalParametroRepository portalParametroRepository;

    @Autowired
    public UltimaAtualizacaoService(UltimaAtualizacaoRepository ultimaAtualizacaoRepository, UltimaAtualizacaoAiseRepository ultimaAtualizacaoAiseRepository, UltimaAtualizacaoServidoresRepository servidoresRepository, PortalParametroRepository portalParametroRepository) {
        this.ultimaAtualizacaoRepository = ultimaAtualizacaoRepository;
        this.ultimaAtualizacaoAiseRepository = ultimaAtualizacaoAiseRepository;
        this.servidoresRepository = servidoresRepository;
        this.portalParametroRepository = portalParametroRepository;
    }

    public List<UltimaAtualizacaoDTO> findUltimasAtualizacoes() {
        UltimaAtualizacaoDTO ultimaAtualizacaoServidores = this.servidoresRepository.ultimaAtualizacaoServidores().stream().findFirst().orElse(null);
        List ultimasAtualizacoes = this.ultimaAtualizacaoRepository.ultimaAtualizacao();
        ultimasAtualizacoes.add(ultimaAtualizacaoServidores);
        return ultimasAtualizacoes;
    }

    public UltimaAtualizacaoDTO getUltimaAtualizacaoByTableAndColumn(String modulo, String table, String column, Long entidade) {
        switch (1.$SwitchMap$br$com$elotech$core$enumerable$common$ModuloEnum[ModuloEnum.getByValue((String)modulo).ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.ultimaAtualizacaoAiseRepository.getUltimaAtualizacao(table, column, this.getCodigoEntidadeAise(entidade));
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.ultimaAtualizacaoRepository.getUltimaAtualizacao(table, column, entidade);
            }
        }
        return this.ultimaAtualizacaoRepository.ultimaAtualizacao().stream().filter(u -> u.getModulo().equals(modulo)).findFirst().orElse(new UltimaAtualizacaoDTO());
    }

    private Long getCodigoEntidadeAise(Long entidade) {
        PortalParametroContabil parametro;
        if (NumberUtils.isBiggerThanZero((Number)entidade).booleanValue() && Objects.nonNull(parametro = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ENTIDADE_AISE)) && parametro.isConfigurado().booleanValue()) {
            return Long.parseLong(parametro.getValor());
        }
        return null;
    }
}

