/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.Comparators;
import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PermutaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.RegistroPontoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosPensaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorResumoNaturezaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidoresHorasExtrasDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.enums.SituacaoServidor;
import br.com.elotech.portaltransparencia.aiseportal.repository.ServidorRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.aiseportal.service.ServidorFolhaPagamentoService;
import br.com.elotech.portaltransparencia.aiseportal.service.ServidorService;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetPermutasEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresParam;
import br.com.elotech.portaltransparencia.aiseportal.ws.service.ServidorServiceWS;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.ParametroRepositoryImpl;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ServidorServiceImpl
implements ServidorService {
    private final ServidorRepository servidorRepository;
    private final PortalParametroService portalParametroService;
    private final EntidadeAiseService entidadeAiseService;
    private final ServidorServiceWS servidorServiceWS;
    private final ServidorFolhaPagamentoService servidoresFolhaPagamentoService;
    private final ParametroRepositoryImpl parametroRepository;

    public ServidorServiceImpl(ServidorRepository servidorRepository, PortalParametroService portalParametroService, EntidadeAiseService entidadeAiseService, ServidorServiceWS servidorServiceWS, ServidorFolhaPagamentoService servidoresFolhaPagamentoService, ParametroRepositoryImpl parametroRepository) {
        this.servidorRepository = servidorRepository;
        this.portalParametroService = portalParametroService;
        this.entidadeAiseService = entidadeAiseService;
        this.servidorServiceWS = servidorServiceWS;
        this.servidoresFolhaPagamentoService = servidoresFolhaPagamentoService;
        this.parametroRepository = parametroRepository;
    }

    public Page<ServidorDTO> loadServidores(ServidorParams params, Pageable pageable) {
        if (this.utilizaFolhaPagamento(params)) {
            return this.servidoresFolhaPagamentoService.loadServidores(params, pageable);
        }
        if (this.utilizaWebService()) {
            return this.getServidoresWS(params, pageable);
        }
        return this.servidorRepository.loadServidores(params, pageable);
    }

    private boolean utilizaFolhaPagamento(ServidorParams params) {
        Parametro parametro = this.parametroRepository.findByEntidadeExercicioModuloAndCodigo(params.getEntidade(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), Parametros.PARAM_HABILITA_INTEGRACAO_FOLHA);
        return Objects.nonNull(parametro) && SimNao.SIM.getSigla().equalsIgnoreCase(parametro.getValor());
    }

    public Page<ServidorDTO> loadAposentadosPensionistas(ServidorParams params, Pageable pageable) {
        if (this.utilizaWebService()) {
            return this.getServidoresWS(params, pageable);
        }
        return this.servidorRepository.loadAposentadosPensionistas(params, pageable);
    }

    private Page<ServidorDTO> getServidoresWS(ServidorParams params, Pageable pageable) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getCpf())) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        List servidores = this.servidorServiceWS.getServidores(params);
        if (this.hasFiltroInformado(params)) {
            servidores = servidores.stream().filter(s -> this.possuiPalavraChave(s, params)).collect(Collectors.toList());
        }
        return this.getServidoresWSPaginado(servidores, pageable, ServidorDTO.class);
    }

    public boolean utilizaWebService() {
        PortalParametroContabil parametro = this.portalParametroService.getPortalParametro(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_WEBSERVICE_MARINGA);
        return Objects.nonNull(parametro) && "1".equals(parametro.getValor());
    }

    private boolean hasFiltroInformado(ServidorParams params) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getNomeServidor()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getSituacao()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getCargo()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getLotacao()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getDescricaoNatureza()) || Objects.nonNull(params.getValorSalarioInicial()) || Objects.nonNull(params.getValorSalarioFinal()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getVinculo());
    }

    protected boolean possuiPalavraChave(ServidorDTO servidor, ServidorParams params) {
        boolean possuiSalarioInicial = true;
        boolean possuiSalarioFinal = true;
        if (Objects.nonNull(params.getValorSalarioInicial()) && Objects.nonNull(servidor.getSalarioBase())) {
            boolean bl = possuiSalarioInicial = params.getValorSalarioInicial().compareTo(servidor.getSalarioBase()) <= 0;
        }
        if (Objects.nonNull(params.getValorSalarioFinal()) && Objects.nonNull(servidor.getSalarioBase())) {
            possuiSalarioFinal = params.getValorSalarioFinal().compareTo(servidor.getSalarioBase()) >= 0;
        }
        return possuiSalarioInicial && possuiSalarioFinal && this.containsFilterEmCampo(params.getNomeServidor(), servidor.getNome()) && this.containsFilterEmCampo(params.getSituacao(), servidor.getSituacao()) && this.containsFilterEmCampo(params.getCargo(), servidor.getDescricaoCargo()) && this.containsFilterEmCampo(params.getLotacao(), servidor.getDescricaoLotacao()) && this.containsFilterEmCampo(params.getDescricaoNatureza(), servidor.getDescricaoNatureza()) && this.containsFilterEmCampo(params.getVinculo(), servidor.getVinculo());
    }

    private boolean containsFilterEmCampo(String filter, String campo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)filter)) {
            return StringUtils.retiraAcentos((String)campo.toUpperCase(Locale.getDefault())).contains(StringUtils.retiraAcentos((String)filter.toUpperCase(Locale.getDefault())));
        }
        return true;
    }

    private <T> Page<T> getServidoresWSPaginado(List<T> servidores, Pageable pageable, Class<T> classType) {
        int recordCount = servidores.size();
        List servidoresPage = this.retrievePage(servidores, pageable, classType);
        List servidoresPageContent = servidoresPage.parallelStream().filter(Objects::nonNull).collect(Collectors.toList());
        return new PageImpl(servidoresPageContent, pageable, (long)recordCount);
    }

    private <T> List<T> retrievePage(List<T> servidores, Pageable pageable, Class<T> classType) {
        Comparator comparator = Comparators.comparingField(classType, (String)"nome");
        if (Objects.nonNull(pageable.getSort()) && pageable.getSort().iterator().hasNext()) {
            Sort.Order order = (Sort.Order)pageable.getSort().iterator().next();
            comparator = Comparators.comparingField(classType, (String)order.getProperty());
            if (order.isDescending()) {
                comparator = comparator.reversed();
            }
        }
        return servidores.stream().sorted(comparator).skip((long)pageable.getPageNumber() * (long)pageable.getPageSize()).limit(pageable.getPageSize()).collect(Collectors.toList());
    }

    public Optional<ServidorDTO> loadServidor(ServidorParams params) {
        if (this.utilizaFolhaPagamento(params)) {
            return this.servidoresFolhaPagamentoService.dadosServidor(params);
        }
        if (this.utilizaWebService()) {
            return this.servidorServiceWS.loadServidorComDadosFinanceiros(params);
        }
        return this.loadServidorComDadosFinanceiros(params);
    }

    private Optional<ServidorDTO> loadServidorComDadosFinanceiros(ServidorParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        Optional servidor = this.servidorRepository.loadServidor(params);
        List dadosFinanceiros = this.servidorRepository.findDadosFinanceirosServidor(params);
        List anotacoes = this.servidorRepository.findAnotacoesServidor(params);
        if (servidor.isPresent()) {
            ((ServidorDTO)servidor.get()).setDadosFinanceiros(dadosFinanceiros);
            ((ServidorDTO)servidor.get()).setAnotacoes(anotacoes);
        }
        return servidor;
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams params) {
        if (this.utilizaFolhaPagamento(params)) {
            return this.servidoresFolhaPagamentoService.loadVencimentosOuDescontos(params);
        }
        if (this.utilizaWebService()) {
            return this.servidorServiceWS.getVencimentoEDescontosWS(params);
        }
        return this.servidorRepository.loadVencimentoEDescontos(params);
    }

    public List<RegistroPontoDTO> loadRegistroPonto(ServidorParams params) {
        if (this.utilizaWebService()) {
            return this.servidorServiceWS.getRegistroPontoWS(params);
        }
        return new ArrayList<RegistroPontoDTO>();
    }

    public List<String> getSituacoes(Long entidade, Long exercicio) {
        ServidorParams params = ServidorParams.builder().entidade(entidade).exercicio(exercicio).build();
        if (this.utilizaFolhaPagamento(params)) {
            return this.servidoresFolhaPagamentoService.getSituacoes(params);
        }
        if (this.utilizaWebService()) {
            TreeSet situacoes = new TreeSet();
            this.servidorServiceWS.getServidores(params).stream().forEach(s -> situacoes.add(s.getSituacao()));
            return new ArrayList<String>(situacoes);
        }
        return Stream.of(SituacaoServidor.values()).map(SituacaoServidor::getDescricao).collect(Collectors.toList());
    }

    public List<ServidorResumoNaturezaDTO> loadServidoresResumoNatureza(ServidorParams params) {
        if (this.utilizaFolhaPagamento(params)) {
            return this.servidoresFolhaPagamentoService.servidoresPorClasse(params);
        }
        if (this.utilizaWebService()) {
            return new ArrayList<ServidorResumoNaturezaDTO>();
        }
        return this.servidorRepository.loadServidoresResumoNatureza(params);
    }

    public Optional<ServidorDadosPensaoDTO> loadPensaoServidor(ServidorParams params) {
        if (this.utilizaWebService() || this.utilizaFolhaPagamento(params)) {
            return Optional.empty();
        }
        return this.servidorRepository.loadPensaoServidor(params);
    }

    public Optional<ServidoresHorasExtrasDTO> loadServidoresHorasExtras(ServidorParams params) {
        if (!this.utilizaWebService()) {
            return Optional.empty();
        }
        return this.servidorServiceWS.getServidoresHorasExtras(params);
    }

    public Page<PermutaDTO> loadPermutas(ServidorParams params, Pageable pageable) {
        if (!this.utilizaWebService()) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        List servidores = this.servidorServiceWS.getPermutas(new GetPermutasEnvio(new GetServidoresParam()));
        return this.getServidoresWSPaginado(servidores, pageable, PermutaDTO.class);
    }
}

