/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorResumoNaturezaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.aiseportal.service.ServidorFolhaPagamentoService;
import br.com.elotech.portaltransparencia.aiseportal.service.impl.ServidorFolhaPagamentoServiceImpl;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.ParametroRepositoryImpl;
import br.com.elotech.portaltransparencia.custom.PageResponse;
import br.com.elotech.portaltransparencia.exception.ParametroMalConfiguradoException;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ServidorFolhaPagamentoServiceImpl
implements ServidorFolhaPagamentoService {
    private final RestTemplate restTemplate;
    private final ParametroRepositoryImpl parametroRepository;
    private final EntidadeAiseService entidadeAiseService;

    public ServidorFolhaPagamentoServiceImpl(RestTemplate restTemplate, ParametroRepositoryImpl portalParametroService, EntidadeAiseService entidadeAiseService) {
        this.restTemplate = restTemplate;
        this.parametroRepository = portalParametroService;
        this.entidadeAiseService = entidadeAiseService;
    }

    public ParametroRepositoryImpl getParametroRepository() {
        return this.parametroRepository;
    }

    public List<ServidorResumoNaturezaDTO> servidoresPorClasse(ServidorParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        if (!this.utilizaFolhaPagamento(params)) {
            return Collections.emptyList();
        }
        String urlIntegracaoFolhaPagamento = this.getUrlIntegracaoFolhaPagamento(params);
        URI uri = URI.create(String.format("%s/servidores-por-classe?entidade=%d&ano=%d", urlIntegracaoFolhaPagamento, params.getEntidadeAise(), params.getExercicio()));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (List)responseEntity.getBody();
        }
        catch (HttpClientErrorException e) {
            return Collections.emptyList();
        }
    }

    public Page<ServidorDTO> loadServidores(ServidorParams params, Pageable pageable) {
        if (!this.utilizaFolhaPagamento(params)) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        String urlIntegracaoFolhaPagamento = this.getUrlIntegracaoFolhaPagamento(params);
        URI uri = UriComponentsBuilder.fromUriString((String)urlIntegracaoFolhaPagamento).path("/servidores").queryParam("page", new Object[]{pageable.getPageNumber()}).queryParam("size", new Object[]{pageable.getPageSize()}).queryParam("sort", new Object[]{pageable.getSort()}).build().toUri();
        RequestEntity requestEntity = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)uri).accept(new MediaType[]{MediaType.APPLICATION_JSON})).contentType(MediaType.APPLICATION_JSON).body((Object)params);
        try {
            2 responseType = new /* Unavailable Anonymous Inner Class!! */;
            ResponseEntity result = this.restTemplate.exchange(requestEntity, (ParameterizedTypeReference)responseType);
            PageResponse pageResponse = (PageResponse)result.getBody();
            return new PageImpl(pageResponse.getContent(), pageable, pageResponse.getTotalElements());
        }
        catch (HttpClientErrorException e) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
    }

    public Optional<ServidorDTO> dadosServidor(ServidorParams params) {
        if (!this.utilizaFolhaPagamento(params)) {
            return Optional.empty();
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        String urlIntegracaoFolhaPagamento = this.getUrlIntegracaoFolhaPagamento(params);
        URI uri = URI.create(String.format("%s/dados-servidor?entidade=%d&ano=%d&matricula=%d", urlIntegracaoFolhaPagamento, params.getEntidadeAise(), params.getExercicio(), params.getMatricula()));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            3 responseType = new /* Unavailable Anonymous Inner Class!! */;
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, (ParameterizedTypeReference)responseType);
            Optional<Object> body = Optional.of(responseEntity.getBody());
            if (Objects.isNull(((ServidorDTO)body.get()).getDadosFinanceiros())) {
                ((ServidorDTO)body.get()).setDadosFinanceiros(new ArrayList());
            }
            if (Objects.isNull(((ServidorDTO)body.get()).getAnotacoes())) {
                ((ServidorDTO)body.get()).setAnotacoes(new ArrayList());
            }
            return body;
        }
        catch (HttpClientErrorException e) {
            return Optional.empty();
        }
    }

    public List<String> getSituacoes(ServidorParams params) {
        if (!this.utilizaFolhaPagamento(params)) {
            return Collections.emptyList();
        }
        String urlIntegracaoFolhaPagamento = this.getUrlIntegracaoFolhaPagamento(params);
        URI uri = URI.create(String.format("%s/situacoes", urlIntegracaoFolhaPagamento));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            4 responseType = new /* Unavailable Anonymous Inner Class!! */;
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, (ParameterizedTypeReference)responseType);
            return (List)responseEntity.getBody();
        }
        catch (HttpClientErrorException e) {
            return Collections.emptyList();
        }
    }

    private boolean utilizaFolhaPagamento(ServidorParams params) {
        Parametro parametro = this.parametroRepository.findByEntidadeExercicioModuloAndCodigo(params.getEntidade(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), Parametros.PARAM_HABILITA_INTEGRACAO_FOLHA);
        return Objects.nonNull(parametro) && SimNao.SIM.getSigla().equalsIgnoreCase(parametro.getValor());
    }

    private String getUrlIntegracaoFolhaPagamento(ServidorParams params) {
        Parametro parametro = this.parametroRepository.findByEntidadeExercicioModuloAndCodigo(params.getEntidade(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), Parametros.PARAM_URL_INTEGRACAO_FOLHA);
        if (Objects.isNull(parametro)) {
            throw new ParametroMalConfiguradoException("A URL de integra\u00e7\u00e3o com a folha de pagamento n\u00e3o est\u00e1 configurada");
        }
        return String.format("%s/integracao/portal-transparencia", parametro.getValor());
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentosOuDescontos(ServidorParams params) {
        if (!this.utilizaFolhaPagamento(params)) {
            return Collections.emptyList();
        }
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        String urlIntegracaoFolhaPagamento = this.getUrlIntegracaoFolhaPagamento(params);
        URI uri = URI.create(String.format("%s/vencimentos-ou-descontos?entidade=%d&ano=%d&mes=%d&matricula=%d&tipoEvento=%s&tipoFolha=%d", urlIntegracaoFolhaPagamento, params.getEntidadeAise(), params.getAnoCompetencia(), params.getMesCompetencia(), params.getMatricula(), params.getTipoEvento(), params.getTipoFolha()));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (List)responseEntity.getBody();
        }
        catch (HttpClientErrorException e) {
            return Collections.emptyList();
        }
    }
}

