/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.web.controller;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoInterface;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.service.LeisAtosService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.util.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api/files"})
@Transactional(readOnly=true)
public class PortalTransparenciaController {
    private static final String UNDERLINE = "_";
    private final ArquivoService arquivoService;
    private final LeisAtosService leisAtosService;
    private final PortalParametroService portalParametroService;
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public PortalTransparenciaController(ArquivoService arquivoService, LeisAtosService leisAtosService, PortalParametroService portalParametroService, @Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.arquivoService = arquivoService;
        this.leisAtosService = leisAtosService;
        this.portalParametroService = portalParametroService;
        this.datasourceWrapper = datasourceWrapper;
    }

    @GetMapping(value={"/ajuda"})
    public void getFileAjuda(HttpServletResponse response) throws IOException {
        byte[] arquivoPDF;
        String fileName = "ajudaportal.pdf";
        String path = "static/files/" + fileName;
        ArquivoInterface eloArquivo = this.portalParametroService.getArquivoAjuda();
        if (Objects.nonNull(eloArquivo)) {
            Arquivo arquivo = this.arquivoService.findOne(eloArquivo.getId());
            fileName = arquivo.getNome();
            arquivoPDF = arquivo.getContent().getBinary();
        } else {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
            arquivoPDF = IOUtils.toByteArray((InputStream)new BufferedInputStream(inputStream));
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivoPDF, (String)fileName);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/arquivo/{id}"})
    public void getArquivo(@PathVariable Long id, HttpServletResponse response) throws IOException {
        Arquivo arquivo = SqlUtils.isPostgres((String)this.datasourceWrapper.getPlatform()) ? this.arquivoService.findArquivoByPart(id) : this.arquivoService.findOne(id);
        if (!(Objects.nonNull(arquivo) && Objects.nonNull(arquivo.getContent()) && Objects.nonNull(arquivo.getContent().getBinary()))) {
            throw RestException.notFound((String)"Arquivo n\u00e3o encontrado!");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo.getContent().getBinary(), (String)arquivo.getNome());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/legislacao/{id}/{idArquivo}/{anoLei}/{natureza}/{tabela}"})
    public void getLegislacao(@PathVariable(value="id") Long id, @PathVariable(value="idArquivo") Long idArquivo, @PathVariable(value="anoLei") Long anoLei, @PathVariable(value="natureza") String natureza, @PathVariable(value="tabela") String tabela, HttpServletResponse response) throws IOException {
        ArquivoDTO arquivoDTO = this.leisAtosService.findArquivoLegislacao(id, idArquivo, anoLei, natureza, tabela);
        this.buildResponse(id, anoLei, natureza, response, arquivoDTO);
    }

    private void buildResponse(Long id, Long ano, String natureza, HttpServletResponse response, ArquivoDTO arquivoDTO) throws IOException {
        if (Objects.nonNull(arquivoDTO) && Objects.nonNull(arquivoDTO.getArquivoFisico())) {
            byte[] arquivoBytes = arquivoDTO.getArquivoFisico();
            StringBuilder nome = new StringBuilder("Legislativo_");
            nome.append(UNDERLINE).append(natureza);
            nome.append(UNDERLINE).append(id);
            nome.append(UNDERLINE).append(ano);
            if (Objects.isNull(arquivoDTO.getNomeArquivo())) {
                nome.append(".pdf");
            } else {
                nome.append(arquivoDTO.getExtensaoNomeArquivo());
            }
            ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivoBytes, (String)nome.toString());
        } else {
            response.setContentType("text/html");
            String naoEncontrado = "Lei e Atos do sistema Legislativo n\u00e3o possui Documento anexado!";
            response.getOutputStream().write(naoEncontrado.getBytes());
        }
    }
}

