/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalOrganograma;
import br.com.elotech.portaltransparencia.contabportal.repository.PortalOrganogramaRepository;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PortalOrganogramaService {
    private final PortalOrganogramaRepository portalOrganogramaRepository;
    private final ArquivoService arquivoService;
    private final EntityManager em;

    @Autowired
    public PortalOrganogramaService(PortalOrganogramaRepository portalOrganogramaRepository, @Qualifier(value="entityManager") EntityManager em, ArquivoService arquivoService) {
        this.portalOrganogramaRepository = portalOrganogramaRepository;
        this.em = em;
        this.arquivoService = arquivoService;
    }

    public List<PortalOrganograma> getOrganograma(Long entidade) {
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"ordem"});
        String search = String.format("entidade==%d", entidade);
        Specification specification = Specification.where((Specification)RsqlUtils.createSpecFrom((EntityManager)this.em, PortalOrganograma.class, (String)search));
        ArrayList list = Lists.newArrayList((Iterable)this.portalOrganogramaRepository.findAll(specification, sort));
        for (PortalOrganograma portalOrganograma : list) {
            if (Objects.nonNull(portalOrganograma.getResumo())) {
                portalOrganograma.setResumo(portalOrganograma.getResumo().replaceAll("(\\r\\n|\\n)", "<br />"));
            }
            if (!Objects.nonNull(portalOrganograma.getArquivo()) || !Objects.nonNull(portalOrganograma.getArquivo().getEloArquivo().getId())) continue;
            portalOrganograma.getArquivo().setTamanhoArquivo(this.arquivoService.getTamanhoArquivo(portalOrganograma.getArquivo().getEloArquivo().getId()));
        }
        return list;
    }
}

