/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.aiseportal.domain.Cargo;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacional;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacionalNivel;
import br.com.elotech.portaltransparencia.aiseportal.domain.QuadroSalarial;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CargoFaixaDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.CargoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/cargos"})
public class CargoResource {
    private final CargoService cargoService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public CargoResource(CargoService cargoService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.cargoService = cargoService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<CargoFaixaDTO>> findCargos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.findCargos(params, pageable));
    }

    @GetMapping(value={"/faixas"})
    public ResponseEntity<List<CargoFaixaDTO>> findFaixas(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.findFaixas(params));
    }

    @GetMapping(value={"/cargos"})
    public ResponseEntity<List<Cargo>> findCargo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.findCargo(params));
    }

    @GetMapping(value={"/quadros"})
    public ResponseEntity<List<QuadroSalarial>> findQuadroSalarial(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.findQuadroSalarial(params));
    }

    @GetMapping(value={"/grupos"})
    public ResponseEntity<List<GrupoOcupacional>> findGrupoOcupacional(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.findGrupoOcupacional(params));
    }

    @GetMapping(value={"/niveis"})
    public ResponseEntity<List<GrupoOcupacionalNivel>> findGrupoOcupacionalNivel(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.cargoService.findGrupoOcupacionalNivel(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportCargos(HttpServletRequest request, HttpServletResponse response, Pageable pageable, @RequestParam(value="entidade", required=true) Long entidade, @RequestParam(value="exercicio", required=true) Long exercicio, @Valid CargoParams params, @RequestParam(value="exportType", required=true) String exportType) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros());
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        Page list = this.cargoService.findCargos(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)entidade);
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Listagem de Cargos");
        reportParam.setClazzDTO(CargoFaixaDTO.class);
        reportParam.setHeaderFields("Cargo,Quadro Salarial,Grupo Ocupacional,N\u00edvel,Vagas Total,Vagas Ocupadas");
        reportParam.setFields("descricao,quadroSalarialDesc,grupoOcupacionalDesc,nivelDesc,vagasTotal,vagasOcupadas");
        float[] fieldsPerc = new float[]{2.0f, 2.0f, 2.0f, 2.0f, 1.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 50, 50, 50, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }
}

