SELECT A.ID, A.NRCONVENIO, A.NRANOCONVENIO, A.LINKGOV, 
  A.DTCELEBRACAO AS DATACELEBRACAO, A.DTINICIOVIGENCIA AS DATAINICIOVIGENCIA, A.DTFIMVIGENCIA AS DATAFIMVIGENCIA, 
  B.FORNECEDOR, B.CNPJ , B.NOME, 
  A.QTPARCELAS, A.DSOBJETO, A.FONTERECURSO, C.DESCRICAO AS DESCRICAOFONTE, A.ENTIDADE, A.VLCONVENIO AS VALORCONVENIO, 
  (SELECT TS.DSTIPOSITUACAOCONVENIO FROM SITUACAOCONVENIO S 
    LEFT OUTER JOIN TIPOSITUACAOCONVENIO TS ON 
    S.IDTIPOSITUACAOCONVENIO = TS.ID  
    WHERE S.ENTIDADE = A.ENTIDADE 
    AND S.IDCONVENIO = A.ID 
    AND S.NRSEQUENCIAL = (SELECT Max(S1.NRSEQUENCIAL) FROM SITUACAOCONVENIO S1 
    WHERE S.ENTIDADE = S1.ENTIDADE 
    AND S.IDCONVENIO = S1.IDCONVENIO)) AS SITUACAO, 
  (SELECT TS.ID FROM SITUACAOCONVENIO S 
    LEFT OUTER JOIN TIPOSITUACAOCONVENIO TS ON 
    S.IDTIPOSITUACAOCONVENIO = TS.ID  
    WHERE S.ENTIDADE = A.ENTIDADE 
    AND S.IDCONVENIO = A.ID 
    AND S.NRSEQUENCIAL = (SELECT Max(S1.NRSEQUENCIAL) FROM SITUACAOCONVENIO S1 
    WHERE S.ENTIDADE = S1.ENTIDADE 
    AND S.IDCONVENIO = S1.IDCONVENIO)) AS IDSITUACAO, 
  (SELECT COALESCE(COUNT(*),0) FROM CADASTROCONVENIOARQUIVO ARQ 
    WHERE A.ENTIDADE = ARQ.ENTIDADE 
    AND A.ID = ARQ.IDCONVENIO) AS TOTALARQUIVO 
FROM CADASTROCONVENIO A 
  LEFT OUTER JOIN FORNECEDOR B 
    ON B.FORNECEDOR = A.FORNECEDORORIGEMDESTINO 
  LEFT OUTER JOIN FONTERECURSO C 
    ON C.FONTERECURSO = A.FONTERECURSO 
WHERE A.ENTIDADE = :entidade 
 