SELECT LIC.ENTIDADE AS ENTIDADE,
       LIC.EXERCICIO AS EXERCICIO,
       LIC.TIPOLICITACAO AS TIPOLICITACAO,
       LIC.LICITACAO AS LICITACAO,
       REQNAD.NUMEROREQUISICAO AS NUMEROREQUISICAO,
       REQNAD.EXERCICIO AS EXERCICIOREQUISICAO,
       REQNAD.DATA AS DATANAD,
       PES.NOME AS NOMEFORNECEDOR,
       NAD.NUMERONAD AS NUMERONAD,
       NAD.EXERCICIO AS EXERCICIONAD,
       NAD.EMPENHO AS EMPENHO,
       REQNAD.VALOR AS VALORREQUISICAO
  FROM APICE.CLREQUISICAONAD REQNAD
  JOIN APICE.CLNAD NAD 
    ON NAD.NAD       = REQNAD.NAD
   AND NAD.EXERCICIO = REQNAD.EXERCICIONAD
   AND NAD.ENTIDADE  = REQNAD.ENTIDADE
   AND NAD.PESSOA    = REQNAD.PESSOA
  LEFT JOIN APICE.CLLICITACAO LIC 
    ON LIC.ENTIDADE      = NAD.ENTIDADELICITACAO
   AND LIC.EXERCICIO     = NAD.EXERCICIOLICITACAO
   AND LIC.TIPOLICITACAO = NAD.TIPOLICITACAO
   AND LIC.LICITACAO     = NAD.LICITACAO
  JOIN APICE.PESSOA PES 
    ON PES.PESSOA = REQNAD.PESSOA
 WHERE LIC.ENTIDADE      = :entidade
   AND LIC.EXERCICIO     = :exercicio
   AND LIC.TIPOLICITACAO = :tipoLicitacao
   AND LIC.LICITACAO     = :licitacao
 ORDER BY REQNAD.DATA