/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.CentroCustoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.converter.CentroCustoConverter;
import br.com.elotech.portaltransparencia.contabportal.repository.CentroCustoRepository;
import br.com.elotech.portaltransparencia.contabportal.service.CentroCustoService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CentroCustoServiceImpl
implements CentroCustoService {
    private final CentroCustoRepository centroCustoRepository;
    private final PortalParametroService parametroService;

    public CentroCustoServiceImpl(CentroCustoRepository repos, PortalParametroService parametroService) {
        this.centroCustoRepository = repos;
        this.parametroService = parametroService;
    }

    public List<CentroCustoDTO> findAllEstocadores(Long entidade, Long exercicio) {
        if (this.mostrarSomenteCentroCustoComMovimentacao(entidade, exercicio).booleanValue()) {
            return this.centroCustoRepository.findByAtivoAndCentroDeOrigemAndComMovimentacaoAndEntidade(entidade);
        }
        return this.centroCustoRepository.findByAtivoTrueAndCentroDeConsumoFalseAndIdEntidadeOrderByIdCentroCusto(entidade).stream().map(CentroCustoConverter::toDTO).collect(Collectors.toList());
    }

    private Boolean mostrarSomenteCentroCustoComMovimentacao(Long entidade, Long exercicio) {
        String valorCentroCustoComMovimentacao = this.parametroService.getPortalParametroValor(entidade, exercicio, Parametros.PARAM_CENTROCUSTO_MOVIMENTACAO);
        return SimNao.toBoolean((String)valorCentroCustoComMovimentacao);
    }
}

