/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ItemEstoqueDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.OrgaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ItemEstoqueRepository;
import br.com.elotech.portaltransparencia.web.rest.params.ItemEstoqueParams;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ItemEstoqueService {
    private final ItemEstoqueRepository itemEstoqueRepository;

    public ItemEstoqueService(ItemEstoqueRepository itemEstoqueRepository) {
        this.itemEstoqueRepository = itemEstoqueRepository;
    }

    public Page<ItemEstoqueDTO> findItemEstoque(ItemEstoqueParams params, Pageable pageable) {
        this.validarParametros(params);
        return this.itemEstoqueRepository.findItemEstoque(params, pageable);
    }

    public List<OrgaoDTO> findOrgao(FindExercicioParams params) {
        return this.itemEstoqueRepository.findOrgao(params);
    }

    private void validarParametros(ItemEstoqueParams params) {
        List violations = this.validarParametrosPesquisaItemEstoque(params);
        if (!violations.isEmpty()) {
            throw new EloValidationException("Campos n\u00e3o informados.", violations);
        }
    }

    private List<EloViolation> validarParametrosPesquisaItemEstoque(ItemEstoqueParams params) {
        ArrayList violations = Lists.newArrayList();
        if (params.getOrgao() == null) {
            violations.add(new EloViolation("O Org\u00e3o n\u00e3o foi informado"));
        }
        return violations;
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        return this.itemEstoqueRepository.findUltimaAtualizacao(params);
    }
}

