/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.service;

import br.com.elotech.portaltransparencia.comprasportal.domain.InteressadoEdital;
import br.com.elotech.portaltransparencia.comprasportal.repository.InteressadoEditalRepository;
import br.com.elotech.portaltransparencia.comprasportal.repository.InteressadoFornecedorRepository;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class InteressadoEditalService {
    private static final int CPF_LENGTH = 11;
    private static final int CNPJ_LENGTH = 14;
    private static final String PESSOAFISICA = "F";
    private static final String PESSOAJURIDICA = "J";
    private static final String USUARIO = "WEB";
    private final InteressadoEditalRepository interessadoEditalRepository;
    private final InteressadoFornecedorRepository interessadoFornecedorRepository;

    public InteressadoEditalService(InteressadoEditalRepository interessadoEditalRepository, InteressadoFornecedorRepository interessadoFornecedorRepository) {
        this.interessadoEditalRepository = interessadoEditalRepository;
        this.interessadoFornecedorRepository = interessadoFornecedorRepository;
    }

    private void setIdInteressado(InteressadoEdital interessadoEdital) {
        if (Objects.isNull(interessadoEdital.getId())) {
            interessadoEdital.setId(this.interessadoEditalRepository.getNextId());
            if (Objects.isNull(interessadoEdital.getInteressadoFornecedor().getId())) {
                interessadoEdital.getInteressadoFornecedor().setId(this.interessadoFornecedorRepository.getNextId());
            }
        }
    }

    public InteressadoEdital save(InteressadoEdital interessadoEdital) {
        this.completarDadosInteressadoEdital(interessadoEdital);
        if (!this.interessadoEditalCadastrado(interessadoEdital)) {
            this.setIdInteressado(interessadoEdital);
            return (InteressadoEdital)this.interessadoEditalRepository.save((Object)interessadoEdital);
        }
        return interessadoEdital;
    }

    private void completarDadosInteressadoEdital(InteressadoEdital interessadoEdital) {
        interessadoEdital.setUsuario(USUARIO);
        interessadoEdital.getInteressadoFornecedor().setUsuario(USUARIO);
        String cpfCnpjSomenteNumero = interessadoEdital.getInteressadoFornecedor().getCpfCnpj().replaceAll("[^0-9]+", "");
        if (cpfCnpjSomenteNumero.length() == 11) {
            interessadoEdital.getInteressadoFornecedor().setTipoPessoa(PESSOAFISICA);
        } else if (cpfCnpjSomenteNumero.length() == 14) {
            interessadoEdital.getInteressadoFornecedor().setTipoPessoa(PESSOAJURIDICA);
        }
    }

    private boolean interessadoEditalCadastrado(InteressadoEdital interessadoEdital) {
        return this.findInteressadoJaCadastrado(interessadoEdital);
    }

    private boolean findInteressadoJaCadastrado(InteressadoEdital interessadoEdital) {
        InteressadoEdital interessado = this.interessadoEditalRepository.findByInteressadoFornecedorEmailAndInteressadoFornecedorCpfCnpjAndTipoLicitacaoAndLicitacao(interessadoEdital.getInteressadoFornecedor().getEmail(), interessadoEdital.getInteressadoFornecedor().getCpfCnpj(), interessadoEdital.getTipoLicitacao(), interessadoEdital.getLicitacao());
        return Objects.nonNull(interessado) && Objects.nonNull(interessado.getId());
    }
}

