/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.FuncaoGratificadaDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FuncaoGratificadaParams;
import br.com.elotech.portaltransparencia.aiseportal.service.FuncaoGratificadaService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/funcao-gratificada"})
public class FuncaoGratificadaResource {
    private final FuncaoGratificadaService funcaoGratificadaService;
    private final ElotechProperties elotechProperties;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public FuncaoGratificadaResource(FuncaoGratificadaService funcaoGratificadaService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.funcaoGratificadaService = funcaoGratificadaService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<FuncaoGratificadaDTO>> loadFuncoesGratificadas(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid FuncaoGratificadaParams funcoesGratificadasParams, Pageable pageable) {
        funcoesGratificadasParams.setEntidade(entidade);
        funcoesGratificadasParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.funcaoGratificadaService.loadFuncoesGratificadas(funcoesGratificadasParams, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportCargos(HttpServletRequest request, HttpServletResponse response, Pageable pageable, @RequestParam(value="entidade", required=true) Long entidade, @Valid FuncaoGratificadaParams params, @RequestParam(value="exportType", required=true) String exportType) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros());
        params.setEntidade(entidade);
        Page list = this.funcaoGratificadaService.loadFuncoesGratificadas(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)entidade);
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Listagem de Fun\u00e7\u00f5es Gratificadas");
        reportParam.setClazzDTO(FuncaoGratificadaDTO.class);
        reportParam.setHeaderFields("Fun\u00e7\u00e3o,Vagas,Ocupagas,Valor");
        reportParam.setFields("descricao,vagas,ocupadas,valor");
        float[] fieldsPerc = new float[]{2.0f, 2.0f, 2.0f, 2.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 50, 50, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }
}

