/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.protocportal.dto.EstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.SerieItemDTO;
import br.com.elotech.portaltransparencia.protocportal.params.EntidadeParams;
import br.com.elotech.portaltransparencia.protocportal.repository.EstatisticaRepository;
import br.com.elotech.portaltransparencia.protocportal.repository.impl.PessoaRepositoryImpl;
import br.com.elotech.portaltransparencia.protocportal.resource.params.EstatisticaParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstatisticaRepositoryImpl
implements EstatisticaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PessoaRepositoryImpl.class);
    private static final String MEDIA_RESPOSTAS_ORACLE = "db/sql/protoc/media-respostas-estatistica-oracle.sql";
    private static final String MEDIA_RESPOSTAS_POSTGRES = "db/sql/protoc/media-respostas-estatistica-postgres.sql";
    private static final String ESTATISTICAS = "db/sql/protoc/estatisticas.sql";
    private static final String PROCESSOS_POR_SEXO = "db/sql/protoc/ProcessosPorSexo.sql";
    private static final String PROCESSOS_POR_IDADE = "db/sql/protoc/ProcessosPorIdade.sql";
    private static final String PROCESSOS_POR_ESCOLARIDADE = "db/sql/protoc/ProcessosPorEscolaridade.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public EstatisticaRepositoryImpl(@Qualifier(value="wrapperProtocolo") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public BigDecimal getMediaResposta(EstatisticaParams params) {
        StringBuilder query = new StringBuilder(this.getSQL());
        params.getExercicio().ifPresent(item -> query.append(" AND A.ANO = :exercicio "));
        this.consoleLogger(query);
        BigDecimal result = (BigDecimal)this.datasourceWrapper.getJdbcTemplate().queryForObject(query.toString(), (SqlParameterSource)params.toJdbcParameter(), BigDecimal.class);
        return result.setScale(2, 4);
    }

    private void consoleLogger(StringBuilder query) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
        }
    }

    public List<EstatisticaDTO> findEstatisticas(EstatisticaParams params) {
        String sql = FileUtils.readResourceAsString((String)ESTATISTICAS);
        StringBuilder filtro = new StringBuilder();
        params.getExercicio().ifPresent(item -> filtro.append(" WHERE E.EXERCICIO = :exercicio "));
        StringBuilder query = new StringBuilder(sql.replace("$[FILTRO]", filtro.toString()));
        this.consoleLogger(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EstatisticaDTO.class));
    }

    private String getSQL() {
        if (SqlUtils.isPostgres((String)this.datasourceWrapper.getPlatform())) {
            return FileUtils.readResourceAsString((String)MEDIA_RESPOSTAS_POSTGRES);
        }
        return FileUtils.readResourceAsString((String)MEDIA_RESPOSTAS_ORACLE);
    }

    public List<SerieItemDTO> findProcessosPorGenero(EntidadeParams params) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_SEXO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SerieItemDTO.class));
    }

    public List<SerieItemDTO> findProcessosPorIdade(EntidadeParams params) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_IDADE);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SerieItemDTO.class));
    }

    public List<SerieItemDTO> findProcessosPorEscolaridade(EntidadeParams params) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_ESCOLARIDADE);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SerieItemDTO.class));
    }
}

