/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AdiantamentoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.AdiantamentoService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/adiantamentos"})
public class AdiantamentoResource {
    private final AdiantamentoService adiantamentoService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public AdiantamentoResource(AdiantamentoService adiantamentoService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.adiantamentoService = adiantamentoService;
    }

    @GetMapping
    public ResponseEntity<Page<AdiantamentoPessoalDTO>> findAdiantamentos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindPessoalParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.adiantamentoService.findAdiantamentos(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findAdiantamentosExport(HttpServletRequest request, HttpServletResponse response, FindPessoalParams params, Pageable pageable) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page list = this.adiantamentoService.findAdiantamentos(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Adiantamento/Reembolso");
        reportParam.setClazzDTO(AdiantamentoPessoalDTO.class);
        reportParam.setHeaderFields("Presta\u00e7\u00e3o,Funcion\u00e1rio,Data Presta\u00e7\u00e3o,Empenho,Data Empenho,Valor Empenho,Valor Notas,Valor Restituido,Cargo,Lota\u00e7\u00e3o");
        reportParam.setFields("prestacaoContas,nome,dataPrestacao,displayEmpenho,dataEmpenho,valorEmpenho,valorDocumentos,valorRestituido,cargo,lotacao");
        float[] fieldsPerc = new float[]{0.9f, 2.0f, 0.9f, 0.9f, 0.9f, 0.9f, 0.9f, 0.9f, 0.9f, 0.9f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{15, 100, 15, 15, 15, 15, 15, 15, 100, 100};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setSumFields("valorEmpenho,valorDocumentos,valorRestituido");
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/total"})
    public ResponseEntity<AdiantamentoPessoalDTO> findTotalAdiantamentos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindPessoalParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.adiantamentoService.findTotalAdiantamentos(params));
    }

    @GetMapping(params={"entidade", "exercicio", "empenho", "noLiquidacao", "unidadeOrcamentaria", "matricula"})
    public ResponseEntity<AdiantamentoPessoalDTO> findAdiantamento(FindPessoalParams params) {
        return this.adiantamentoService.findAdiantamento(params).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi poss\u00edvel encontrar este adiantamento/reembolso."));
    }

    @GetMapping(value={"/prestacao-contas"}, params={"entidade", "exercicio", "prestacaoContas"})
    public ResponseEntity<AdiantamentoPessoalDTO> findPrestacaoContas(FindPessoalParams params) {
        return this.adiantamentoService.findPrestacaoContas(params).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi poss\u00edvel encontrar este adiantamento/reembolso"));
    }

    @GetMapping(value={"/arquivos"}, params={"entidade", "exercicio", "prestacaoContas"})
    public ResponseEntity<List<ArquivoPessoalDTO>> findArquivos(FindPessoalParams params) {
        return ResponseEntity.ok((Object)this.adiantamentoService.findArquivos(params));
    }
}

