SELECT X.NOME,
       X.CNPJCPF,
       X.FORNECEDOR,
       SUM(X.EMPENHADO) AS EMPENHADO,
       SUM(X.ANULADO) AS ANULADO,
       SUM(X.LIQUIDADO) AS LIQUIDADO,
       SUM(X.RETIDO) AS RETIDO,
       SUM(X.PAGO) AS PAGO,
       SUM(X.EMPENHADO - X.ANULADO - X.RETIDO - X.PAGO) AS APAGAR
  FROM (SELECT E.EXERCICIO,
               E.EMPENHO,
               F.NOME,
               CASE
                 WHEN F.TIPOPESSOA = 'F' THEN
                  '****' || SUBSTR(F.CNPJ, 5, 3) || '****'
                 ELSE
                  F.CNPJ
               END AS CNPJCPF,
               F.FORNECEDOR,
               SUM(FE.VALOR) AS EMPENHADO,
               SUM(FE.VALORANULACOES - FE.VALORESTANULACOES) AS ANULADO,
               SUM(FE.VALORLIQUIDACOES - FE.VALORESTLIQUIDACOES) AS LIQUIDADO,
               SUM(FE.VALORRETENCOES) AS RETIDO,
               SUM(FE.VALORPAGAMENTO - FE.VALORESTPAGAMENTO) AS PAGO
          FROM EMPENHO E
          LEFT OUTER JOIN FORNECEDOR F ON E.FORNECEDOR = F.FORNECEDOR
          LEFT OUTER JOIN FICHAEMPENHO FE ON E.ENTIDADE = FE.ENTIDADE
		        AND E.EXERCICIO = FE.EXERCICIO
		        AND E.EMPENHO = FE.EMPENHO
		        AND E.UNIDADEORCAMENTARIA = FE.UNIDADEORCAMENTARIA
          $[FILTRO]
         GROUP BY E.EXERCICIO,
                  E.EMPENHO,
                  F.NOME,
                  CASE
                    WHEN F.TIPOPESSOA = 'F' THEN
                     '****' || SUBSTR(F.CNPJ, 5, 3) || '****'
                    ELSE
                     F.CNPJ
                  END,
                  F.FORNECEDOR) X
WHERE (X.EMPENHADO - X.ANULADO - X.RETIDO - X.PAGO) >= 0.01
 GROUP BY X.NOME, X.CNPJCPF, X.FORNECEDOR
