/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosNaturezaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisVinculadasDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.LeisAtosRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LeisAtosRepositoryImpl
implements LeisAtosRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeisAtosRepositoryImpl.class);
    private static final String LEISATOS = "db/sql/contab/leisatos.sql";
    private static final String LEISATOS_ARQUIVOS = "db/sql/contab/leisatos_arquivo.sql";
    private static final String LEISVINCULADAS = "db/sql/contab/leisVinculadas.sql";
    public static final String SCHEMA_AISE = "schema_aise";
    public static final String SCHEMA_SISCOP = "schema_siscop";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public LeisAtosRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<LeisAtosDTO> findLeisAtos(LeisAtosParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LEISATOS));
        query.append("\n AND A.ENTIDADE = :entidade");
        if (params.getSubAbaLeiAtos().isPresent() && !"geral".equals(params.getSubAbaLeiAtos().get())) {
            query.append(String.format(" AND A.MOSTRAR%s = 'S'", ((String)params.getSubAbaLeiAtos().get()).toUpperCase(Locale.getDefault())));
        }
        params.getAno().ifPresent(item -> query.append("\n   AND A.EXERCICIO = :ano "));
        params.getNatureza().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(C.DESCRICAO)) LIKE tiraacento(UPPER(:natureza)) "));
        params.getNumero().ifPresent(item -> query.append("   AND A.NUMERO = :numero "));
        params.getDescricao().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(B.DESCRICAO)) LIKE tiraacento(UPPER(:descricao)) "));
        params.getSumula().ifPresent(item -> query.append("\n   AND tiraacento(UPPER(A.SUMULA)) LIKE tiraacento(UPPER(:sumula)) "));
        params.getDataInicial().ifPresent(item -> query.append("\n   AND A.DATA >= :dataInicial "));
        params.getDataFinal().ifPresent(item -> query.append("\n   AND A.DATA <= :dataFinal "));
        params.getTipoDocumentoLegal().ifPresent(item -> query.append("\n   AND TDL.CODIGO = :tipoDocumentoLegal "));
        params.getTipoEscopo().ifPresent(item -> query.append("\n AND B.CODIGO = :tipoEscopo "));
        this.loggerSql(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
    }

    private void loggerSql(StringBuilder query) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
        }
    }

    public List<LeisAtosDTO> findOneLeiAto(LeisAtosParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LEISATOS));
        params.getId().ifPresent(id -> query.append("   AND A.ID = :id "));
        this.loggerSql(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
    }

    public List<LeisVinculadasDTO> findLeisVinculadas(Long entidade, Long exercicio, Long idLeiVinculadora) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LEISVINCULADAS));
        MapSqlParameterSource params = new MapSqlParameterSource();
        query.append(" WHERE V.ENTIDADE = :entidade ");
        query.append("   AND V.IDLEIVINCULADORA = :id ");
        params.addValue("entidade", (Object)entidade, 2);
        params.addValue("exercicio", (Object)exercicio, 2);
        params.addValue("id", (Object)idLeiVinculadora, 2);
        this.loggerSql(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LeisVinculadasDTO.class));
    }

    public List<LeisAtosNaturezaDTO> findLeisAtosNatureza() {
        StringBuilder query = new StringBuilder();
        query.append(" SELECT N.ID, N.CODIGO, N.DESCRICAO FROM naturezalei N ");
        query.append(" ORDER BY N.CODIGO ");
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosNaturezaDTO.class));
    }

    public List<LeisAtosNaturezaDTO> findTiposDocumentoLegal() {
        StringBuilder query = new StringBuilder();
        query.append(" SELECT a.codigo, a.descricao FROM tipodocumentolegal a ");
        query.append("\n ORDER BY a.descricao");
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosNaturezaDTO.class));
    }

    public List<LeisAtosNaturezaDTO> findTiposEscopo() {
        StringBuilder query = new StringBuilder();
        query.append(" SELECT T.* FROM TIPOESCOPO T ");
        query.append(" WHERE T.VERSAO = (SELECT MAX(VERSAO) FROM TIPOESCOPO) ");
        query.append(" ORDER BY T.DESCRICAO ");
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosNaturezaDTO.class));
    }

    public List<LeisAtosArquivoDTO> findLeisArquivos(Long entidade, Long exercicio, Long id) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LEISATOS_ARQUIVOS).replace("schema_eloarquivo", "ELOARQUIVO"));
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("IDLEIATO", (Object)id, 2);
        this.loggerSql(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosArquivoDTO.class));
    }
}

